/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.gui.FontAttributes;
import ordermate.gui.LimitedColorSelector;
import ordermate.gui.PlusMinusPanel;
import ordermate.gui.model.NullableEventComboBoxModel;

public class FontAttributesEditor
extends JPanel
implements ActionListener,
ChangeListener {
    private static final Integer DEFAULT_MIN_SIZE = 1;
    private static final Integer DEFAULT_MAX_SIZE = 72;
    private LimitedColorSelector colourSelector;
    private PlusMinusPanel sizePanel;
    private JCheckBox boldCheck;
    private JCheckBox italicCheck;
    private JComboBox familyCombo;
    private FontAttributes attributes;
    private boolean listening = true;

    public FontAttributesEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        EventList fontList = GlazedLists.eventList(FontAttributes.getAvailableFontFamilies());
        NullableEventComboBoxModel familyComboModel = new NullableEventComboBoxModel(fontList, "<Default>");
        this.colourSelector = new LimitedColorSelector(true);
        this.colourSelector.allowNull(true);
        this.colourSelector.setAvailableColors(null);
        this.boldCheck = new JCheckBox("Bold");
        this.italicCheck = new JCheckBox("Italic");
        this.familyCombo = new JComboBox(familyComboModel);
        this.familyCombo.setPreferredSize(new Dimension(120, 25));
        ComponentUtils.setupComboBox(this.familyCombo);
        this.sizePanel = new PlusMinusPanel(DEFAULT_MIN_SIZE, DEFAULT_MAX_SIZE);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.sizePanel);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.colourSelector);
        this.add(this.familyCombo);
        this.add(this.boldCheck);
        this.add(this.italicCheck);
        this.add(Box.createGlue());
        this.colourSelector.addActionListener(this);
        this.sizePanel.addChangeListener(this);
        this.boldCheck.addActionListener(this);
        this.italicCheck.addActionListener(this);
        this.familyCombo.addActionListener(this);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (this.sizePanel != null) {
            this.sizePanel.setFont(newFont);
            this.colourSelector.setFont(newFont);
        }
    }

    public void setAttributes(FontAttributes newAttributes) {
        this.attributes = newAttributes;
        if (this.attributes != null) {
            this.listening = false;
            this.colourSelector.setSelectedColor(this.attributes.getColour());
            this.boldCheck.setSelected(this.attributes.isBold());
            this.italicCheck.setSelected(this.attributes.isItalic());
            this.familyCombo.setSelectedItem(this.attributes.getFontFamily());
            int size = this.attributes.getPointSize();
            this.sizePanel.setValue(size);
            this.listening = true;
        }
    }

    public FontAttributes getAttributes() {
        return this.attributes;
    }

    private void updateAttributes() {
        if (this.listening && this.attributes != null) {
            this.attributes.setPointSize(this.sizePanel.getValue());
            this.attributes.setColour(this.colourSelector.getSelectedColor());
            this.attributes.setBold(this.boldCheck.isSelected());
            this.attributes.setItalic(this.italicCheck.isSelected());
            this.attributes.setFontFamily((String)this.familyCombo.getSelectedItem());
            this.firePropertyChange("attributes", this.attributes, this.attributes);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateAttributes();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateAttributes();
    }

    public void setSizeIconsAndText(Icon plusIcon, String plusText, Icon minusIcon, String minusText) {
        this.sizePanel.setPlusMinusIcons(plusIcon, minusIcon);
        this.sizePanel.setPlusMinusText(plusText, minusText);
    }
}

