/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.util.StringUtils;
import java.awt.event.KeyEvent;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.Device;
import ordermate.database.hardware.physical.ProximityReader;
import ordermate.database.misc.BarcodeUtils;
import ordermate.gui.CaptureKeyboard;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class InputAdapter {
    private boolean parsingEnabled = true;
    public final Signal<String, ?, ?, ?, ?> barcodeInput = Signals.createSignal(String.class, "input");
    public final Signal<String, ?, ?, ?, ?> swipecardInput = Signals.createSignal(String.class, "input");
    public final Signal<String, ?, ?, ?, ?> proximityReaderInput = Signals.createSignal(String.class, "input");
    private static final int MAX_SPECIAL_STRING_BUFFER = 256;
    public final Signal<KeyEvent, ?, ?, ?, ?> lostEvent = Signals.createSignal(KeyEvent.class, "keyEvent");
    private StringBuilder enteredString = new StringBuilder();

    public InputAdapter() {
        if (CaptureKeyboard.getInstance() != null) {
            CaptureKeyboard.getInstance().keyPressed.connect(this, "gotKeyPressed");
        } else {
            OrderMate.LOG.error("Could not obtain a CaptureKeyboard instance.");
        }
    }

    public void gotInput(String input) {
        String cardInput;
        if (BarcodeUtils.isBarcodeString(input)) {
            this.emitBarcode(input);
        }
        if (StringUtils.isSwipeCardString(cardInput = BarcodeUtils.stripExternalPrefix(input))) {
            this.swipecardInput.emit(cardInput);
        }
    }

    public void gotKeyPressed(KeyEvent e) {
        OrderMate.LOG.debug("Got key pressed : " + e);
        if (e.getID() == 401) {
            if (KeyEvent.getKeyText(e.getKeyCode()).equalsIgnoreCase("Enter")) {
                this.gotInput(this.enteredString.toString());
                this.enteredString = new StringBuilder();
                this.lostEvent.emit(e);
            }
        } else if (e.getID() == 400) {
            if (this.enteredString.length() > 256) {
                this.enteredString = new StringBuilder();
            }
            this.enteredString.append(e.getKeyChar());
            this.lostEvent.emit(e);
        }
    }

    protected void emitBarcode(String input) {
        String data = BarcodeUtils.stripBarcodeDelimiter(input);
        this.barcodeInput.emit(data);
    }

    public void gotProximityReader(Device theDevice) {
        ProximityReader reader;
        String newString;
        if (theDevice instanceof ProximityReader && !(newString = (reader = (ProximityReader)theDevice).getDataAsString()).equals("")) {
            this.proximityReaderInput.emit(newString);
        }
    }

    public void enableInputParsing(boolean enabled) {
        this.parsingEnabled = enabled;
    }

    public boolean isInputParsingEnabled() {
        return this.parsingEnabled;
    }

    protected void resetInputBuffer() {
        this.enteredString = new StringBuilder();
    }
}

