/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class JXTransformer
extends JPanel {
    private Component glassPane = new MagicGlassPane();
    private Component view;
    private Rectangle visibleRect;
    private Map<?, ?> renderingHints;
    private BufferedImage blitBoy = new BufferedImage(100, 100, 1);
    private AffineTransform at;

    public JXTransformer() {
        this((JComponent)null);
    }

    public JXTransformer(JComponent aView) {
        this(aView, new AffineTransform());
    }

    public JXTransformer(JComponent aView, AffineTransform anAT) {
        super(null);
        this.setTransform(anAT);
        super.addImpl(this.glassPane, null, 0);
        this.setView(aView);
        Handler handler = new Handler();
        this.addHierarchyBoundsListener(handler);
        this.addComponentListener(handler);
    }

    public Component getView() {
        return this.view;
    }

    public void setView(Component newView) {
        if (this.getView() != null) {
            super.remove(this.getView());
        }
        if (newView != null) {
            super.addImpl(newView, null, 1);
        }
        this.view = newView;
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    public Map<?, ?> getRenderingHints() {
        if (this.renderingHints == null) {
            return null;
        }
        return new HashMap(this.renderingHints);
    }

    public void setRenderingHints(Map<?, ?> newHints) {
        this.renderingHints = newHints == null ? null : new HashMap(newHints);
        this.repaint();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.setView(comp);
    }

    @Override
    public void remove(int index) {
        Component c = this.getComponent(index);
        if (c != this.view) {
            if (c == this.glassPane) {
                throw new IllegalArgumentException("GlassPane can't be removed");
            }
            throw new AssertionError((Object)("Unknown component with index " + index));
        }
        this.view = null;
        super.remove(index);
    }

    @Override
    public void removeAll() {
        this.remove(this.view);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (mgr != null) {
            throw new IllegalArgumentException("Only null layout is supported");
        }
        super.setLayout(mgr);
    }

    @Override
    public void doLayout() {
        if (this.view != null) {
            this.view.setSize(this.view.getPreferredSize());
            this.visibleRect = this.getVisibleRect();
            this.view.setLocation(this.visibleRect.x, this.visibleRect.y);
        }
        this.glassPane.setLocation(0, 0);
        this.glassPane.setSize(this.getWidth(), this.getHeight());
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.blitBoy = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension size = this.getTransformedSize().getSize();
        Insets insets = this.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    private Rectangle getTransformedSize() {
        if (this.view != null) {
            Dimension viewSize = this.view.getSize();
            Rectangle viewRect = new Rectangle(viewSize);
            return this.at.createTransformedShape(viewRect).getBounds();
        }
        return new Rectangle(super.getPreferredSize());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)this.blitBoy.getGraphics();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle bounds = this.getBounds();
        Rectangle tb = this.getTransformedSize();
        if (this.view != null && this.at.getDeterminant() != 0.0) {
            Insets insets = this.getInsets();
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            double centerX1 = bounds.getCenterX();
            double centerY1 = bounds.getCenterY();
            double centerX2 = tb.getCenterX();
            double centerY2 = tb.getCenterY();
            if (this.renderingHints != null) {
                g2.addRenderingHints(this.renderingHints);
            }
            double tx = centerX1 - centerX2 - (double)this.getX();
            double ty = centerY1 - centerY2 - (double)this.getY();
            g2.translate((int)tx, (int)ty);
            g2.transform(this.at);
            this.view.paint(g2);
        }
        if (this.getTopLevelAncestor() != null) {
            Dimension topLevelDimension = this.getTopLevelAncestor().getSize();
            g.setColor(this.getBackground());
            int widthDiff = (tb.width - topLevelDimension.width) / 2;
            int heightDiff = (tb.height - topLevelDimension.height) / 2;
            g.setClip(widthDiff, heightDiff, topLevelDimension.width, topLevelDimension.height + heightDiff + 15);
            g.fillRect(widthDiff, heightDiff, topLevelDimension.width, topLevelDimension.height + heightDiff + 15);
        }
        g.drawImage(this.blitBoy, 0, 0, null);
        this.paintBorder(g);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.at);
    }

    public void setTransform(AffineTransform newAT) {
        if (newAT == null) {
            throw new IllegalArgumentException("AffineTransform is null");
        }
        this.at = new AffineTransform(newAT);
        this.revalidate();
        this.repaint();
    }

    public void rotate(double theta) {
        AffineTransform transform = this.getTransform();
        transform.rotate(theta);
        this.setTransform(transform);
    }

    public void scale(double sx, double sy) {
        AffineTransform transform = this.getTransform();
        transform.scale(sx, sy);
        this.setTransform(transform);
    }

    public void shear(double sx, double sy) {
        AffineTransform transform = this.getTransform();
        transform.shear(sx, sy);
        this.setTransform(transform);
    }

    private class Handler
    extends ComponentAdapter
    implements HierarchyBoundsListener {
        private Handler() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.update();
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            this.update();
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            this.update();
        }

        private void update() {
            if (!JXTransformer.this.getVisibleRect().equals(JXTransformer.this.visibleRect)) {
                JXTransformer.this.revalidate();
            }
        }
    }

    private class MagicGlassPane
    extends JPanel {
        private Component mouseEnteredComponent;
        private Component mouseDraggedComponent;
        private Component mouseCurrentComponent;

        public MagicGlassPane() {
            super(null);
            this.setOpaque(false);
            this.enableEvents(16L);
            this.enableEvents(32L);
            this.enableEvents(131072L);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        private MouseEvent transformMouseEvent(MouseEvent event) {
            MouseEvent newEvent;
            if (event == null) {
                throw new IllegalArgumentException("MouseEvent is null");
            }
            if (event instanceof MouseWheelEvent) {
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)event;
                newEvent = new MouseWheelEvent(mouseWheelEvent.getComponent(), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
            } else {
                newEvent = new MouseEvent(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
            }
            if (JXTransformer.this.view != null && JXTransformer.this.at.getDeterminant() != 0.0) {
                Point2D tp;
                Rectangle viewBounds = JXTransformer.this.getTransformedSize();
                Insets insets = JXTransformer.this.getInsets();
                int xgap = (this.getWidth() - (viewBounds.width + insets.left + insets.right)) / 2;
                int ygap = (this.getHeight() - (viewBounds.height + insets.top + insets.bottom)) / 2;
                double x = (double)newEvent.getX() + viewBounds.getX() - (double)insets.left;
                double y = (double)newEvent.getY() + viewBounds.getY() - (double)insets.top;
                Point2D.Double p = new Point2D.Double(x - (double)xgap, y - (double)ygap);
                try {
                    tp = JXTransformer.this.at.inverseTransform(p, null);
                }
                catch (NoninvertibleTransformException ex) {
                    throw new AssertionError((Object)"NoninvertibleTransformException");
                }
                this.mouseCurrentComponent = SwingUtilities.getDeepestComponentAt(JXTransformer.this.view, (int)tp.getX(), (int)tp.getY());
                if (this.mouseCurrentComponent == null) {
                    this.mouseCurrentComponent = JXTransformer.this;
                }
                Component tempComponent = this.mouseCurrentComponent;
                if (this.mouseDraggedComponent != null) {
                    tempComponent = this.mouseDraggedComponent;
                }
                Point point = SwingUtilities.convertPoint(JXTransformer.this.view, (int)tp.getX(), (int)tp.getY(), tempComponent);
                newEvent.setSource(tempComponent);
                newEvent.translatePoint(point.x - event.getX(), point.y - event.getY());
            }
            return newEvent;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            MouseEvent transformedEvent = this.transformMouseEvent(e);
            switch (e.getID()) {
                case 504: {
                    if (this.mouseDraggedComponent != null && this.mouseCurrentComponent != this.mouseDraggedComponent) break;
                    this.dispatchMouseEvent(transformedEvent);
                    break;
                }
                case 505: {
                    if (this.mouseEnteredComponent == null) break;
                    this.dispatchMouseEvent(this.createEnterExitEvent(this.mouseEnteredComponent, 505, e));
                    this.mouseEnteredComponent = null;
                    break;
                }
                case 502: {
                    if (this.mouseDraggedComponent != null && e.getButton() == 1) {
                        transformedEvent.setSource(this.mouseDraggedComponent);
                        this.mouseDraggedComponent = null;
                    }
                    this.dispatchMouseEvent(transformedEvent);
                    break;
                }
                default: {
                    this.dispatchMouseEvent(transformedEvent);
                }
            }
            super.processMouseEvent(e);
        }

        private void dispatchMouseEvent(MouseEvent event) {
            MouseListener[] mouseListeners;
            block7: for (MouseListener listener : mouseListeners = event.getComponent().getMouseListeners()) {
                if (listener.getClass().getName().startsWith("javax.swing.ToolTipManager")) continue;
                switch (event.getID()) {
                    case 501: {
                        listener.mousePressed(event);
                        continue block7;
                    }
                    case 502: {
                        listener.mouseReleased(event);
                        continue block7;
                    }
                    case 500: {
                        listener.mouseClicked(event);
                        continue block7;
                    }
                    case 505: {
                        listener.mouseExited(event);
                        continue block7;
                    }
                    case 504: {
                        listener.mouseEntered(event);
                        continue block7;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            MouseMotionListener[] mouseMotionListeners;
            MouseEvent transformedEvent = this.transformMouseEvent(e);
            if (this.mouseEnteredComponent == null) {
                this.mouseEnteredComponent = this.mouseCurrentComponent;
            }
            switch (e.getID()) {
                case 503: {
                    if (this.mouseCurrentComponent == this.mouseEnteredComponent) break;
                    this.dispatchMouseEvent(this.createEnterExitEvent(this.mouseEnteredComponent, 505, e));
                    this.dispatchMouseEvent(this.createEnterExitEvent(this.mouseCurrentComponent, 504, e));
                    break;
                }
                case 506: {
                    if (this.mouseDraggedComponent == null) {
                        this.mouseDraggedComponent = this.mouseEnteredComponent;
                    }
                    if (this.mouseEnteredComponent == this.mouseDraggedComponent && this.mouseCurrentComponent != this.mouseDraggedComponent) {
                        this.dispatchMouseEvent(this.createEnterExitEvent(this.mouseDraggedComponent, 505, e));
                    } else if (this.mouseEnteredComponent != this.mouseDraggedComponent && this.mouseCurrentComponent == this.mouseDraggedComponent) {
                        this.dispatchMouseEvent(this.createEnterExitEvent(this.mouseDraggedComponent, 504, e));
                    }
                    if (this.mouseDraggedComponent == null) break;
                    transformedEvent.setSource(this.mouseDraggedComponent);
                }
            }
            this.mouseEnteredComponent = this.mouseCurrentComponent;
            block8: for (MouseMotionListener listener : mouseMotionListeners = transformedEvent.getComponent().getMouseMotionListeners()) {
                if (listener.getClass().getName().startsWith("javax.swing.ToolTipManager")) continue;
                switch (transformedEvent.getID()) {
                    case 503: {
                        listener.mouseMoved(transformedEvent);
                        continue block8;
                    }
                    case 506: {
                        listener.mouseDragged(transformedEvent);
                        continue block8;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            super.processMouseMotionEvent(e);
        }

        @Override
        protected void processMouseWheelEvent(MouseWheelEvent e) {
            MouseWheelListener[] mouseWheelListeners;
            MouseWheelEvent transformedEvent = (MouseWheelEvent)this.transformMouseEvent(e);
            for (MouseWheelListener listener : mouseWheelListeners = transformedEvent.getComponent().getMouseWheelListeners()) {
                listener.mouseWheelMoved(transformedEvent);
            }
            super.processMouseWheelEvent(e);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (this.mouseEnteredComponent instanceof JComponent) {
                return ((JComponent)this.mouseEnteredComponent).getToolTipText();
            }
            return null;
        }

        private MouseEvent createEnterExitEvent(Component c, int eventId, MouseEvent mouseEvent) {
            return new MouseEvent(c, eventId, mouseEvent.getWhen(), 0, mouseEvent.getX(), mouseEvent.getY(), 0, false, 0);
        }

        @Override
        public String toString() {
            return "GlassPane";
        }
    }
}

