/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.FontManagerUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationTargetException;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.gui.themes.OrderMateTheme;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.SubstanceFontUtilities;

public class LaFManager {
    public void updateComponent(Component comp, SubstanceLookAndFeel laf, int fontSize) {
        SubstanceLookAndFeel.setFontPolicy((FontPolicy)SubstanceFontUtilities.getScaledFontPolicy((float)((float)fontSize / 10.0f)));
        FontManagerUtil.setupFonts(fontSize);
        if (laf != null) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)laf);
            }
            catch (UnsupportedLookAndFeelException ex) {
                OrderMate.LOG.warn("Couldn't set look and feel : " + laf);
            }
        }
        OrderMateTheme.initFonts();
        if (comp != null) {
            SwingUtilities.updateComponentTreeUI(comp);
            comp.invalidate();
            comp.validate();
            comp.repaint();
        }
    }

    private Font loadInFont(String name, int fontSize) {
        Font theFont = null;
        try {
            theFont = Font.createFont(0, LaFManager.class.getResourceAsStream(name));
            theFont = theFont.deriveFont(fontSize);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(theFont);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't load font:", (Throwable)ex);
        }
        return theFont;
    }

    public void updateComponent(Component comp, Terminal terminal) throws ClassNotFoundException {
        String className = terminal.getLookAndFeelClassName();
        SubstanceLookAndFeel laf = this.loadLookAndFeel(className);
        int fontSize = terminal.getGuiFontSize();
        if (fontSize == 0) {
            fontSize = Config.getIntValue("Scale") + 10;
        }
        this.updateComponent(comp, laf, fontSize);
    }

    public void configureLaF(final Terminal term) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    LaFManager.this.updateComponent(null, term);
                }
                catch (ClassNotFoundException cnf) {
                    OrderMate.LOG.error("Could not load look and feel", (Throwable)cnf);
                }
            }
        });
    }

    public SubstanceLookAndFeel loadLookAndFeel(String className) throws ClassNotFoundException {
        try {
            if (className != null && className.contains("substance")) {
                OrderMate.LOG.info("Loading LaF class : " + className);
                Class<?> lafClass = LaFManager.class.getClassLoader().loadClass(className);
                return (SubstanceLookAndFeel)lafClass.newInstance();
            }
            OrderMate.LOG.warn("LaF Class is null or did not contain substance " + className);
        }
        catch (IllegalAccessException ex1) {
            OrderMate.LOG.warn("Could not load look and feel, no public constructor", (Throwable)ex1);
        }
        catch (InstantiationException ex2) {
            OrderMate.LOG.warn("Could not instantiate look and feel. ", (Throwable)ex2);
        }
        return null;
    }
}

