/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import ordermate.OrderMate;

public class LimitedColorSelector
extends JPanel
implements ActionListener {
    private JButton colorChooserBut;
    private JComboBox colorCombo;
    private EventList<Color> availableColours = new BasicEventList();
    private boolean allowNull;
    private NullableColorEditor editor;
    private NullableColorRenderer renderer;

    public LimitedColorSelector() {
        this(true);
    }

    public LimitedColorSelector(boolean chooserVisible) {
        this.setupComponents();
        this.setColorChooserVisible(chooserVisible);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (this.colorCombo != null) {
            this.colorCombo.setFont(newFont);
            this.colorChooserBut.setFont(newFont);
            this.colorCombo.updateUI();
        }
    }

    private void setupComponents() {
        this.colorChooserBut = new JButton("Choose...");
        this.colorChooserBut.addActionListener(this);
        EventComboBoxModel colourModel = new EventComboBoxModel(this.availableColours);
        this.colorCombo = new JComboBox(colourModel);
        this.colorCombo.setEditable(true);
        this.renderer = new NullableColorRenderer();
        this.colorCombo.setRenderer(this.renderer);
        this.editor = new NullableColorEditor();
        this.colorCombo.setEditor(this.editor);
        this.add(this.colorCombo);
        this.add(this.colorChooserBut);
    }

    public Color getSelectedColor() {
        return (Color)this.colorCombo.getSelectedItem();
    }

    public void setSelectedColor(Color value) {
        this.colorCombo.setSelectedItem(value);
    }

    public void addActionListener(ActionListener listener) {
        this.colorCombo.addActionListener(listener);
    }

    public void setAvailableColors(List<Color> colours) {
        this.availableColours.clear();
        if (this.allowNull) {
            this.availableColours.add(null);
        }
        if (colours == null || colours.size() == 0) {
            this.availableColours.addAll(this.getDefaultColours());
        } else {
            this.availableColours.addAll(colours);
        }
    }

    public void allowNull(boolean value) {
        this.allowNull = value;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setColorChooserEnabled(boolean value) {
        this.colorChooserBut.setEnabled(value);
    }

    public boolean isColorChooserEnabled() {
        return this.colorChooserBut.isEnabled();
    }

    public void setColorChooserVisible(boolean value) {
        this.colorChooserBut.setVisible(value);
    }

    public boolean isColorChooserVisible() {
        return this.colorChooserBut.isVisible();
    }

    private void chooseColor() {
        Color color = null;
        try {
            color = JColorChooser.showDialog(this, "Select a Color...", (Color)this.colorCombo.getSelectedItem());
            this.setSelectedColor(color);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot select a colour!", (Throwable)ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorChooserBut) {
            this.chooseColor();
        }
    }

    private Collection<Color> getDefaultColours() {
        ArrayList<Color> newList = new ArrayList<Color>();
        newList.add(Color.BLACK);
        newList.add(Color.WHITE);
        newList.add(Color.PINK);
        newList.add(Color.RED);
        newList.add(Color.ORANGE);
        newList.add(Color.YELLOW);
        newList.add(Color.GREEN);
        newList.add(Color.CYAN);
        newList.add(Color.BLUE);
        newList.add(Color.MAGENTA);
        newList.add(Color.GRAY);
        newList.add(Color.DARK_GRAY);
        newList.add(Color.LIGHT_GRAY);
        return newList;
    }

    public final Object getComboBox() {
        return this.colorCombo;
    }

    static class NullableColorEditor
    extends JLabel
    implements ComboBoxEditor {
        private Color selectedColour;

        public NullableColorEditor() {
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(100, 30));
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.selectedColour;
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void setItem(Object anObject) {
            this.selectedColour = (Color)anObject;
            if (this.selectedColour != null) {
                this.setBackground(this.selectedColour);
                this.setText(" ");
            } else {
                this.setBackground(null);
                this.setText("None");
            }
        }
    }

    static class NullableColorRenderer
    extends JLabel
    implements ListCellRenderer {
        public NullableColorRenderer() {
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(100, 30));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.setBackground((Color)value);
                this.setText(" ");
            } else {
                this.setBackground(null);
                this.setText("None");
            }
            return this;
        }
    }
}

