/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.util.StringUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class MultiLineLabel
extends JLabel {
    private String[] splits = new String[0];
    private int cachedWidth = -1;
    private int lineHeight;
    private int descent;
    private int leftIndent = 0;

    public int getLeftIndent() {
        return this.leftIndent;
    }

    public void setLeftIndex(int value) {
        this.leftIndent = value;
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.relayout(width);
    }

    @Override
    public void setText(String value) {
        super.setText(value);
        this.relayout(this.getPreferredSize() == null ? this.getWidth() : this.getPreferredSize().width);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.relayout(this.getPreferredSize() == null ? this.getWidth() : this.getPreferredSize().width);
    }

    @Override
    public int getHeight() {
        if (this.splits == null) {
            return 0;
        }
        return this.lineHeight * this.splits.length + this.descent;
    }

    @Override
    public Rectangle bounds() {
        Rectangle rect = super.getBounds();
        rect.width = this.cachedWidth;
        rect.height = this.getHeight();
        return rect;
    }

    @Override
    public Dimension size() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    private boolean relayout(int forWidth) {
        if (this.cachedWidth == forWidth) {
            return false;
        }
        Font font = this.getFont();
        if (font == null && (font = UIManager.getFont("Label.font")) == null) {
            return false;
        }
        this.splitText(font, forWidth - this.leftIndent);
        this.cachedWidth = forWidth;
        Dimension dim = new Dimension(this.cachedWidth, this.getHeight());
        this.setBounds(this.getX(), this.getY(), dim.width, dim.height);
        super.setSize(dim);
        super.setMinimumSize(dim);
        super.setPreferredSize(dim);
        super.setMaximumSize(dim);
        this.revalidate();
        return true;
    }

    private void splitText(Font font, int reqWidth) {
        String text = String.valueOf(this.getText());
        List<String> words = StringUtils.splitToList(text, " ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder SB = new StringBuilder();
        int wordCount = 0;
        FontMetrics metrics = this.getFontMetrics(font);
        this.lineHeight = metrics.getHeight();
        this.descent = metrics.getDescent();
        for (String word : words) {
            SB.append(word).append(" ");
            if (wordCount > 0) {
                int width = metrics.charsWidth(SB.toString().toCharArray(), 0, SB.length());
                if (width <= reqWidth) continue;
                SB.replace(SB.length() - word.length() - 1, SB.length() - 1, "");
                lines.add(SB.toString());
                SB = new StringBuilder(word).append(" ");
                wordCount = 1;
                continue;
            }
            ++wordCount;
        }
        lines.add(SB.toString());
        this.splits = new String[lines.size()];
        this.splits = lines.toArray(this.splits);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.relayout(this.getParent().getWidth())) {
            this.getParent().validate();
            this.getParent().repaint();
            return;
        }
        g.setClip(0, 0, this.getWidth() + this.leftIndent, this.getHeight());
        if (this.isOpaque() && this.getBackground() != null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (int i = 0; i < this.splits.length; ++i) {
            ((Graphics2D)g).drawString(this.splits[i], this.leftIndent, (1 + i) * this.lineHeight);
        }
    }
}

