/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.VolatileImage;
import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.RepaintManager;
import ordermate.OrderMate;

public class OMRepaintManager
extends RepaintManager {
    private final int MAX = 2;
    private Map<GraphicsConfiguration, VolatileImage> reflectMap;

    public OMRepaintManager() {
        OrderMate.LOG.info("Attempting to override RepaintManager vMap");
        try {
            Field field = this.getClass().getSuperclass().getDeclaredField("volatileMap");
            field.setAccessible(true);
            this.reflectMap = (Map)field.get(this);
            OrderMate.LOG.info("RepaintManager manager over");
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot access the underlying volatile map", (Throwable)ex);
        }
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        Image superImage = super.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
        if (this.reflectMap != null && this.reflectMap.size() > 2) {
            OrderMate.LOG.info("V map size " + this.reflectMap.size() + " reducing");
            GraphicsConfiguration realConfig = c.getGraphicsConfiguration();
            VolatileImage img = this.reflectMap.get(realConfig);
            this.reflectMap.clear();
            this.reflectMap.put(realConfig, img);
        }
        return superImage;
    }
}

