/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.gui.themes.OrderMateTheme;

public class PlusMinusPanel
extends JPanel
implements ActionListener {
    private JLabel valueLabel;
    private JButton plusButton;
    private JButton minusButton;
    private NumberFormat myFormat;
    private int value;
    private int increment = 1;
    private Integer lower;
    private Integer upper;
    private boolean wrap = false;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public PlusMinusPanel(Integer lowerBound, Integer upperBound) {
        this(lowerBound, upperBound, 0);
    }

    public PlusMinusPanel(Integer lowerBound, Integer upperBound, int orientation) {
        this.lower = lowerBound;
        this.upper = upperBound;
        this.setupComponents(orientation);
    }

    private void setupComponents(int orientation) {
        this.setLayout(new BorderLayout());
        this.valueLabel = new JLabel();
        this.valueLabel.setName("value");
        JPanel buttonPanel = new JPanel();
        if (orientation == 1) {
            buttonPanel.setLayout(new GridLayout(2, 1));
        } else {
            buttonPanel.setLayout(new GridLayout(1, 2));
        }
        this.plusButton = new JButton("+");
        this.plusButton.setName("plus");
        this.plusButton.setIcon(IconLoader.get("/ordermate/images/plus.png"));
        this.minusButton = new JButton("-");
        this.minusButton.setName("minus");
        this.minusButton.setIcon(IconLoader.get("/ordermate/images/minus.png"));
        OrderMateTheme.setupTransparentButton(this.plusButton);
        OrderMateTheme.setupTransparentButton(this.minusButton);
        this.plusButton.addActionListener(this);
        this.minusButton.addActionListener(this);
        this.add((Component)this.valueLabel, "Center");
        buttonPanel.add(this.plusButton);
        buttonPanel.add(this.minusButton);
        this.add((Component)buttonPanel, "East");
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (this.valueLabel != null) {
            this.valueLabel.setFont(newFont);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setPlusMinusIcons(Icon plusIcon, Icon minusIcon) {
        this.plusButton.setIcon(plusIcon);
        this.minusButton.setIcon(minusIcon);
    }

    public void setPlusMinusText(String plusText, String minusText) {
        this.plusButton.setText(plusText);
        this.minusButton.setText(minusText);
    }

    public void setValue(int newValue) {
        int oldValue = this.value;
        this.value = this.lower != null && newValue < this.lower ? (this.wrap ? this.upper.intValue() : this.lower.intValue()) : (this.upper != null && newValue > this.upper ? (this.wrap ? this.lower.intValue() : this.upper.intValue()) : newValue);
        this.firePropertyChange("value", oldValue, this.value);
        this.updateLabel();
    }

    public int getValue() {
        return this.value;
    }

    public void setFormat(NumberFormat format) {
        this.myFormat = format;
    }

    private void updateLabel() {
        if (this.myFormat == null) {
            this.valueLabel.setText("" + this.value);
        } else {
            this.valueLabel.setText(this.myFormat.format(this.value));
        }
        this.valueLabel.validate();
        this.valueLabel.repaint();
    }

    private void increment() {
        this.setValue(this.value + this.increment);
    }

    private void decrement() {
        this.setValue(this.value - this.increment);
    }

    public void setWrap(boolean value) {
        this.wrap = value && this.lower != null && this.upper != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.plusButton) {
            this.increment();
        } else if (e.getSource() == this.minusButton) {
            this.decrement();
        }
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        if (this.listeners.size() > 0) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener nextListener : this.listeners) {
                nextListener.stateChanged(e);
            }
        }
    }

    public void setIncrement(int newInc) {
        this.increment = newInc;
    }
}

