/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.action.ActionManager;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.giftvoucher.VoucherAdministrator;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.action.ActionFireOn;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.PrintAccount;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.stock.StockUtilities;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroupHelper;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.AbstractSaveAccount;
import ordermate.gui.VoucherPrinting;
import ordermate.gui.delivery.DeliveryGuiHelper;
import ordermate.gui.delivery.DeliveryHandler;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.integration.bartabs.BarTabAdministrator;
import ordermate.integration.onlinesales.OnlineOrderRetryWorker;
import ordermate.integrity.TradingDayFinanceChangesExecutable;
import ordermate.internationalization.Internationalization;
import ordermate.services.misc.CallMethod;
import ordermate.services.misc.CallMethodOnClassExecutable;

public abstract class SaveAccount
extends AbstractSaveAccount {
    private final PrintAccount printAccount;
    private static VoucherAdministrator admin;
    private CourseChange courseChange = null;

    protected SaveAccount(GuiHandler gui, PrintAccount yourPrintAccount) {
        super(gui);
        this.printAccount = yourPrintAccount;
    }

    public static void setDefaultVoucherAdminInstance(VoucherAdministrator value) {
        if (admin != null && !admin.equals(value)) {
            throw new IllegalStateException("Cannot set the administrator once already set");
        }
        admin = value;
    }

    protected PrintAccount getPrintAccount() {
        return this.printAccount;
    }

    private void printTransfer(Account source, Account destination) {
        try {
            PrepDocketHelper.create(source).printTransferPrepDockets(destination, Terminal.getLocalHost());
            source.save();
        }
        catch (Exception e) {
            this.getPrintAccount().handlePrinterError(e, "account " + destination.getLabel());
        }
    }

    public boolean isCloseAllowed(Account account, boolean allowCloseFree) {
        if (!account.isOpen()) {
            OrderMate.LOG.info("Cannot close an already closed account " + account.getLabel() + " : " + account.getID());
            return false;
        }
        if (!account.isClosePossible()) {
            OrderMate.LOG.info("Cannot close account when close is not possible " + account.getLabel() + " : " + account.getID());
            return false;
        }
        if (this.hasPendingOnlineOrders(account)) {
            return false;
        }
        Payable.PaidState paidState = account.getPaidState();
        if (paidState.equals(Payable.CREDIT) || paidState.equals(Payable.NOT_PAID)) {
            OrderMate.LOG.info("Cannot close account that is " + paidState + " for " + account.getLabel() + " : " + account.getID());
            return false;
        }
        if (paidState.equals(Payable.UNPAYABLE)) {
            if (account.getItems().isEmpty()) {
                if (account.isSaveEmptyAllowed()) {
                    return account.isPersistent() && this.confirmCloseZeroDollarAccount(account);
                }
                return true;
            }
            if (allowCloseFree) {
                return true;
            }
            if (LoyaltyPointAdministrator.getInstance().isAtLeastOneLoyaltyRedemption(account)) {
                return true;
            }
            return this.confirmCloseZeroDollarAccount(account);
        }
        if (paidState.equals(Payable.PAID)) {
            if (account.isSaveEmptyAllowed()) {
                return this.confirmCloseZeroDollarAccount(account);
            }
            if (!account.hasPayments() && !allowCloseFree) {
                if (LoyaltyPointAdministrator.getInstance().isAtLeastOneLoyaltyRedemption(account)) {
                    return true;
                }
                return this.confirmCloseZeroDollarAccount(account);
            }
            return true;
        }
        if (paidState.equals(Payable.UNPAYABLE_BY_ROUNDING)) {
            return allowCloseFree ? true : this.confirmCloseRoundedToZeroDollarAccount(account);
        }
        throw new IllegalStateException(paidState + " is not one of the four expected paid states.");
    }

    private boolean confirmCloseZeroDollarAccount(Account toClose) {
        if (toClose.hasSellables() && toClose instanceof BarTabAccount && ((BarTabAccount)toClose).isIntegrationAccount() && BarTabAdministrator.getInstance().forceCloseZeroDollarAccountsAfterSettlement((BarTabAccount)toClose)) {
            return true;
        }
        StringBuilder builder = new StringBuilder("This ");
        builder.append(toClose.getAccountType().getLabel());
        builder.append(" account is ");
        if (!toClose.hasSellables()) {
            builder.append(" empty. ");
        } else {
            builder.append(" worth " + Internationalization.getLiteralFor("DOLLAR_SIGN") + "0. ");
        }
        builder.append(" Close this account?");
        return this.getGui().displayForcedChoiceDialog("Close Account?", builder.toString(), "Yes", "No");
    }

    private boolean confirmCloseRoundedToZeroDollarAccount(Account toClose) {
        StringBuilder builder = new StringBuilder("This ");
        builder.append(toClose.getAccountType().getLabel());
        builder.append(" account can be rounded to " + Internationalization.getLiteralFor("DOLLAR_SIGN") + "0. Close this account?");
        return this.getGui().displayForcedChoiceDialog("Close Account?", builder.toString(), "Yes", "No");
    }

    public boolean closeAccount(Account toClose, boolean save, boolean allowCloseFree, EventContext context) {
        return this.closeAccount(toClose, save, allowCloseFree, context, false);
    }

    public boolean closeAccount(Account toClose, boolean save, boolean allowCloseFree, EventContext context, boolean isTransfer) {
        this.performPreClose(toClose, context);
        boolean printVouchers = false;
        if (this.isCloseAllowed(toClose, allowCloseFree)) {
            toClose.close(context);
            printVouchers = true;
            if (isTransfer) {
                toClose.disableNotifyClosed();
            }
        }
        if (save) {
            this.saveAccount(toClose, "NORMAL", context, isTransfer);
        }
        if (printVouchers) {
            new VoucherPrinting(context).printPrintClose(toClose);
        }
        return !toClose.isOpen();
    }

    protected boolean performPreClose(Account toClose, EventContext context) {
        return true;
    }

    public VoucherAdministrator getVoucherAdmin() {
        return admin;
    }

    public List<SalesLineItem> performTransfer(Account source, Account target, List<SalesLineItem> itemList, EventContext context) {
        return this.performTransfer(source, target, itemList, true, context, true);
    }

    public List<SalesLineItem> performTransfer(Account source, Account target, List<SalesLineItem> itemList, EventContext context, boolean printTransfer) {
        return this.performTransfer(source, target, itemList, true, context, printTransfer);
    }

    public List<SalesLineItem> performTransfer(Account source, final Account target, List<SalesLineItem> itemList, boolean markPrinted, EventContext context, boolean printTransfer) {
        if (!target.getPriceAdjustments().isEmpty() && !source.getPriceAdjustments().isEmpty()) {
            if (SystemProperty.getInstance().isWarnOnRemoveDiscountWhenTransfer()) {
                this.getGui().displayOkDialog("Discounts and Surcharges Removed", "<HTML>The destination account has a discount or surcharge.<BR>Discounts and surcharges have been removed from the transferred items.");
            }
            for (SalesLineItem lineItem : itemList) {
                for (SalesItem salesItem : lineItem.getSalesItems()) {
                    for (SalesComponent comp : salesItem.getComponentList()) {
                        for (SalesPriceAdjustmentUsage usage : new ArrayList<SalesPriceAdjustmentUsage>(comp.getPriceAdjustmentUsages())) {
                            if (!usage.getSalesPriceAdjustment().getLevel().equals(PriceAdjustmentLevel.ACCOUNT_LEVEL)) continue;
                            comp.removePriceAdjustmentUsage(usage);
                        }
                    }
                }
            }
        }
        List<SalesLineItem> newItems = source.getItemHelper().transferItemsTo(target, itemList, markPrinted, context);
        PreauthTransaction preAuthTxn = null;
        if (this.isCloseAllowed(source, false) && !this.shouldKeepOpen(source) && this.closeAccount(source, false, false, context, true)) {
            preAuthTxn = PersistenceManager.getObject(PreauthTransaction.class, PreauthTransaction.getExisting(source).toString());
        }
        if (!target.hasComment()) {
            target.setComment(source.getComment());
        }
        if (!(source instanceof PhoneAccount) && !source.hasItems()) {
            source.setComment(source.getLabel() + " is transferred into " + target.getLabel());
        }
        this.saveAccount(source, "NONE", context, true);
        this.printClosingReceipts(source);
        if (!target.hasTicketData()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SaveAccount.this.getTicketData(target);
                        }
                    });
                }
                catch (Exception e) {
                    OrderMate.LOG.error("Error occurred getting ticket data on event thread", (Throwable)e);
                }
            } else {
                this.getTicketData(target);
            }
        }
        target.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        boolean isNew = !target.isPersistent();
        this.saveAccount(target, "NONE", context, true);
        if (preAuthTxn != null) {
            preAuthTxn.setAccount(target);
            preAuthTxn.save();
        }
        if (printTransfer) {
            this.printTransfer(source, target);
        }
        if (target instanceof TableAccount) {
            this.notifyReservationIntegrator(AccountOperationType.TRANSFER, source, target, isNew);
        }
        target.unlock();
        source.unlock();
        return newItems;
    }

    public boolean getTicketData(Account account) {
        return true;
    }

    public boolean moreCustomers() {
        boolean keepOpen = false;
        keepOpen = this.getGui().displayForcedChoiceDialog("More customers", "Are there any more customers to serve for this account?", "Yes", "No");
        return keepOpen;
    }

    public boolean shouldKeepOpen(Account toClose) {
        boolean keepOpen;
        if (!(toClose instanceof TableAccount)) {
            return false;
        }
        boolean bl = keepOpen = !this.isCloseAllowed(toClose, false);
        if (!keepOpen) {
            List<Reservation> res;
            if (Terminal.getLocalHost().isBistroMode()) {
                keepOpen = this.getGui().displayForcedChoiceDialog("More customers", "Are there any more customers to serve for this account?", "Yes", "No");
                if (!keepOpen && Terminal.getLocalHost().isBistroKeepOpen()) {
                    keepOpen = this.getGui().displayForcedChoiceDialog("Keep Open?", "Would you like to keep this table open?", "Yes", "No");
                }
            } else if (toClose.getItems().isEmpty()) {
                List<Reservation> res2 = ReservationsHelper.getReservationsForTableAccount((TableAccount)toClose);
                if (res2 != null && !res2.isEmpty()) {
                    keepOpen = this.getGui().displayForcedChoiceDialog("Keep Open?", "There is currently a reservation assigned to this table. Keep it open?", "Yes", "No");
                }
            } else if (ReservationIntegrationUtils.isCloudReservationsConfigured() && ReservationIntegrationType.DIAMONDBACK.equals((Object)SystemProperty.getInstance().getReservationIntegration()) && Price.ZERO_DOLLAR.equals(toClose.getDue()) && (res = ReservationsHelper.getReservationsForTableAccount((TableAccount)toClose)) != null && !res.isEmpty() && toClose.getFinanceTransactions().size() == 1 && toClose.getFinanceTransactions().get(0) instanceof WebTransaction && toClose.getFinanceTransactions().get(0).isPersistent()) {
                keepOpen = this.getGui().displayForcedChoiceDialog("Keep Open?", "There is a reservation assigned to this table. The balance is zero. Keep it open?", "Yes", "No");
            }
        }
        return keepOpen;
    }

    public void saveAndTransferToBarTabAccount(BarTabAccount barTab, Account sourceAccount, List<? extends SalesLineItem> items, EventContext context, boolean printTransfer) {
        this.saveAccount(sourceAccount, context);
        this.printPrep(sourceAccount);
        List printers = Terminal.getLocalHost().getAvailableAccountPayoffPrinters();
        if (!printers.isEmpty()) {
            this.printClosingReceipts(sourceAccount, printers);
        }
        User lockingUser = sourceAccount.getUser();
        this.performTransfer(sourceAccount, barTab, items, context, printTransfer);
        barTab.lock(context.getUser());
        this.saveAccount(barTab, "NONE", context, false);
        if (!sourceAccount.isLocked()) {
            sourceAccount.lock(lockingUser);
        }
        this.saveAccount(sourceAccount, "NONE", context, false);
    }

    public void saveAccount(Account toSave, EventContext context) {
        this.saveAccount(toSave, "NORMAL", context, false);
    }

    protected void saveAccount(final Account toSave, final String stockUsage, final EventContext context, boolean isTransferAccount) {
        this.performPreSave(toSave, context);
        boolean isNew = !toSave.isPersistent();
        boolean isIntegratorNotifiable = false;
        LogicalTable preTable = null;
        if (toSave instanceof TableAccount) {
            isIntegratorNotifiable = !isTransferAccount;
            preTable = ((TableAccount)toSave).getTable();
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SaveAccount.this.doSaveAccount(toSave, stockUsage, context);
                    }
                });
            }
            catch (InterruptedException ex) {
                OrderMate.LOG.error("InterruptedException caught from saveAccount: ", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                OrderMate.LOG.error("InvocationTargetException caught from saveAccount: ", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        } else {
            this.doSaveAccount(toSave, stockUsage, context);
        }
        if (isIntegratorNotifiable) {
            this.notifyReservationIntegrator(isNew ? AccountOperationType.CREATE : AccountOperationType.UPDATE, toSave, null, isNew);
        }
        if (!toSave.isOpen() && preTable != null) {
            this.revertTables(preTable);
        }
        this.performPostSave(toSave, context);
        this.notifyFinanceChangeManager(toSave);
    }

    private void revertTables(LogicalTable table) {
        ArrayList<PhysicalTable> phTables;
        ExperimentalFeature revertTables;
        if (ReservationIntegrationType.DIAMONDBACK.equals((Object)SystemProperty.getInstance().getReservationIntegration()) && (revertTables = ExperimentalFeature.find("DiamondBack Revert Tables")) != null && revertTables.getBooleanValue(Boolean.TRUE).booleanValue() && (phTables = new ArrayList<PhysicalTable>(table.getPhysicalTables())).size() > 1) {
            TableGroupHelper helper = table.getTableGroup().getHelper();
            helper.breakUpTable(table);
            table.saveChild();
            for (PhysicalTable phTable : phTables) {
                helper.returnToPermanentPosition(phTable);
                phTable.saveChild();
            }
            table.getTableGroup().save();
        }
    }

    private void notifyReservationIntegrator(AccountOperationType type, Account source, Account target, boolean isNew) {
        switch (type) {
            case CREATE: {
                ReservationIntegrationUtils.reservationAccountCreated(source);
                break;
            }
            case UPDATE: {
                ReservationIntegrationUtils.reservationAccountUpdated(source);
                break;
            }
            case TRANSFER: {
                ReservationIntegrationUtils.reservationAccountTransferred(source, target, isNew);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid account operation type!");
            }
        }
    }

    private void performPreSave(Account toSave, EventContext context) {
        if (ActionManager.getInstance() != null) {
            ActionManager.getInstance().triggerAction(ActionFireOn.PreSave, new TriggerActivationContext(context, new Date(), toSave));
        }
        VirtualPrinter printerForDeletion = context.getTerminal().getAutoPrintOnDelete();
        VirtualPrinter printerForAdjustment = context.getTerminal().getAutoPrintOnAdjustment();
        if (printerForDeletion != null && !toSave.hasUnsavedDeletedItems()) {
            printerForDeletion = null;
        }
        if (printerForAdjustment != null && !toSave.getPriceAdjHelper().isUnprintedAdjustment()) {
            printerForAdjustment = null;
        }
        if (printerForDeletion != null && printerForAdjustment != null && printerForDeletion.getPrintDevice().equals(printerForAdjustment.getPrintDevice())) {
            toSave.setReceiptPrintReason("Auto Print: Price Adjustment,Items Deleted");
        } else {
            if (printerForDeletion != null) {
                toSave.setReceiptPrintReason("Auto Print: Items Deleted");
            }
            if (printerForAdjustment != null) {
                toSave.setReceiptPrintReason("Auto Print: Price Adjustment");
            }
        }
    }

    private void performPostSave(Account toProcess, EventContext context) {
        if (!toProcess.isOpen()) {
            try {
                if (this.getVoucherAdmin() != null && toProcess.getVoucherTxns() != null && !toProcess.getVoucherTxns().isEmpty()) {
                    this.getVoucherAdmin().confirmTransactions(toProcess.getVoucherTxns());
                }
            }
            catch (RemoteException ex) {
                OrderMate.LOG.warn("Cannot perform voucher confirmations.", (Throwable)ex);
            }
        }
        if (toProcess.getReceiptPrintReason() != null) {
            VirtualPrinter printerForDeletion = null;
            VirtualPrinter printerForAdjustment = null;
            String reason = toProcess.getReceiptPrintReason();
            if (reason.contains("Price Adjustment")) {
                printerForAdjustment = context.getTerminal().getAutoPrintOnAdjustment();
            }
            if (reason.contains("Items Deleted")) {
                printerForDeletion = context.getTerminal().getAutoPrintOnDelete();
            }
            if (printerForDeletion != null && printerForAdjustment != null && printerForDeletion.getPrintDevice().equals(printerForAdjustment.getPrintDevice())) {
                this.getPrintAccount().doPrintReceipt(toProcess, Arrays.asList(printerForAdjustment));
            } else {
                if (printerForDeletion != null) {
                    this.getPrintAccount().doPrintReceipt(toProcess, Arrays.asList(printerForDeletion));
                }
                if (printerForAdjustment != null) {
                    this.getPrintAccount().doPrintReceipt(toProcess, Arrays.asList(printerForAdjustment));
                }
            }
            toProcess.setReceiptPrintReason(null);
        }
        if (ActionManager.getInstance() != null) {
            ActionManager.getInstance().triggerAction(ActionFireOn.PostSave, new TriggerActivationContext(context, new Date(), toProcess));
        }
        this.autoAssignToDelivery(toProcess);
    }

    protected User getAutoAssignedDriver(PhoneAccount phoneAccount) {
        if (!SystemProperty.getInstance().canAssignDriver(phoneAccount.getDriverAssignmentSettlementTypeForAccount())) {
            OrderMate.LOG.info("Cannot assign drivers, therefore marking account as delivered.");
            phoneAccount.setDelivered();
            phoneAccount.save();
            return null;
        }
        return PersistenceManager.getObject(User.class, Query.select(User.class).active(User.class).equals(User.Properties.AUTO_ASSIGN, Boolean.TRUE).toString());
    }

    public void autoAssignToDelivery(Account toProcess) {
        PhoneAccount phoneAccount;
        if (toProcess.isDeliverable() && !(phoneAccount = (PhoneAccount)toProcess).isDelivered() && phoneAccount.getDelivery() == null) {
            User autoDriver;
            if (phoneAccount instanceof OnlineAccount) {
                if (phoneAccount.getEta() == null) {
                    OrderMate.LOG.info("Not going to auto-assign online account since no ETA has been set.");
                    return;
                }
                OnlineIntegrationConfig config = OnlineIntegrationConfig.getConfigFor(((OnlineAccount)phoneAccount).getSource());
                OnlineIntegrationConfig.PrintingStrategy printing = config.getPrintingStrategy();
                if (!(OnlineIntegrationConfig.PrintingStrategy.ALWAYS.equals((Object)printing) || ((OnlineAccount)phoneAccount).isAcknowledged() || Price.ZERO_DOLLAR.equals(phoneAccount.getDue()))) {
                    OrderMate.LOG.info("Not going to auto-assign online account, since not acknowledged and printing is Paid only");
                    return;
                }
            }
            if ((autoDriver = this.getAutoAssignedDriver(phoneAccount)) != null && (autoDriver.isClockedOn() || autoDriver.getDriverTrackingId() != null)) {
                OrderMate.LOG.info("Auto Assigning to " + autoDriver);
                User lockingUser = phoneAccount.getUser();
                DummyGUIHandler gui = new DummyGUIHandler();
                DeliveryHandler handler = new DeliveryHandler(new DeliveryGuiHelper(gui), gui);
                handler.handleDeliveryAssignment(Collections.singletonList(phoneAccount), autoDriver, lockingUser);
                phoneAccount.relock(lockingUser);
            } else {
                OrderMate.LOG.info("No user has been set for auto-assign, will not even try.");
            }
        }
    }

    private void notifyFinanceChangeManager(Account account) {
        if (!account.getTradingDay().isOpen()) {
            final HashSet<Long> tradingDays = new HashSet<Long>();
            tradingDays.add(account.getTradingDay().getID());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PersistenceManager.getServerConnection().runSync(new TradingDayFinanceChangesExecutable(tradingDays));
                }
            }).start();
        }
    }

    protected final void printClosingReceipts(Account toClose, List printers) {
        this.getPrintAccount().printClosingReceipts(toClose, printers);
    }

    public void printClosingReceipts(Account toClose) {
        List printers;
        if (toClose.isPersistent() && !toClose.isOpen() && !(printers = this.getAvailablePayoffPrinters(toClose)).isEmpty()) {
            this.printClosingReceipts(toClose, printers);
        }
    }

    public void printPaidOffReceipts(Account account, EventContext context) {
        boolean isPaid = Price.ZERO_DOLLAR.equals(account.getDue(0.01));
        if (isPaid) {
            this.saveAccount(account, "NORMAL", context, false);
            List printers = this.getAvailablePayoffPrinters(account);
            if (!printers.isEmpty()) {
                this.printClosingReceipts(account, printers);
            }
        }
    }

    private List getAvailablePayoffPrinters(Account account) {
        List<VirtualPrinter> printers = account.isDebtorSale() ? Terminal.getLocalHost().getAvailableAccountPayoffPrinters() : (!account.getFinanceTransactions().isEmpty() || account.hasSellables() ? Terminal.getLocalHost().getAvailablePayoffPrinters(account.getFinanceTransactions()) : new ArrayList<VirtualPrinter>());
        return printers;
    }

    public void printReceiptDockets(ItemGroup toPrint, EventContext context) {
        this.printReceiptDockets(Collections.singletonList(toPrint), context);
    }

    public void printReceiptDockets(ItemGroup toPrint) {
        this.printReceiptDockets(Collections.singletonList(toPrint));
    }

    public void printReceiptDockets(List itemGroupsToPrint) {
        this.getPrintAccount().printReceiptDockets(itemGroupsToPrint);
    }

    public void printReceiptDockets(List itemGroupsToPrint, EventContext context) {
        this.getPrintAccount().printReceiptDockets(itemGroupsToPrint, context);
    }

    public void printPrep(Account toPrint) {
        this.printPrep(toPrint, null);
    }

    public void printPrep(Account toPrint, EventContext context) {
        Terminal terminal = Terminal.getLocalHost();
        if (context != null && context.getTerminal() != null) {
            terminal = context.getTerminal();
        }
        try {
            if (SystemProperty.getInstance().isSingleCoursePrinting() && toPrint instanceof TableAccount && !AccountType.onlineTableType.equals(toPrint.getAccountType()) && toPrint.hasPrintableItems()) {
                Course course = ((TableAccount)toPrint).getCurrentCourse();
                if (course != null) {
                    DocketProcessor.printPrepDocketForCourse(toPrint, toPrint.getUser(), terminal, course.getCourseIndex());
                }
            } else if (toPrint.hasPrintableItems()) {
                toPrint.printPrepDockets(terminal);
            }
        }
        catch (Exception e) {
            this.getPrintAccount().handlePrinterError(e, "account " + toPrint.getLabel());
        }
    }

    public void printRushedPrep(Account toPrint) {
        try {
            if (toPrint.hasPrintableItems()) {
                PrepDocketHelper.create(toPrint).printPrepDockets(Terminal.getLocalHost(), false, true);
            }
        }
        catch (Exception e) {
            this.getPrintAccount().handlePrinterError(e, "account " + toPrint.getLabel());
        }
    }

    public void handlePrinterError(Exception e, String string) {
        this.getPrintAccount().handlePrinterError(e, string);
    }

    public boolean printOrder(Account currentAccount, EventContext eventContext) {
        boolean printed = false;
        if (StockUtilities.checkAccountOversell(currentAccount)) {
            this.saveAccount(currentAccount, eventContext);
            this.printRushedPrep(currentAccount);
            printed = true;
        }
        return printed;
    }

    public void setTableState(LogicalTableState state, LogicalTable table, EventContext context, boolean printImmediately) {
        TableAccount tableAccount;
        if (state != null && state.getCourse() != null && table.getAccount() == null) {
            return;
        }
        boolean needToUnlockTable = false;
        boolean needToUnlockAccount = false;
        User currentUser = context.getUser();
        if (!table.isLocked(currentUser)) {
            if (table.lock(currentUser)) {
                needToUnlockTable = true;
            } else {
                return;
            }
        }
        table.updateTableState(state, context);
        Course course = null;
        if (state != null && state.getCourse() != null) {
            course = state.getCourse();
        }
        if ((state == null || course != null) && (tableAccount = table.getAccount()) != null) {
            if (!tableAccount.isLocked(currentUser) && tableAccount.lock(currentUser)) {
                needToUnlockAccount = true;
            }
            Course currentCourse = tableAccount.getCurrentCourse();
            tableAccount.setCurrentCourse(course);
            this.markAccountForCoursePrinting(currentCourse, course, new EventContext(Terminal.getLocalHost(), currentUser), tableAccount);
            if (printImmediately) {
                this.printCourseDockets();
            }
            if (needToUnlockAccount) {
                tableAccount.save();
                tableAccount.unlock();
            }
        }
        if (needToUnlockTable) {
            table.saveChild();
            table.unlock();
        }
    }

    private void markAccountForCoursePrinting(Course currentCourse, Course newCourse, EventContext context, TableAccount account) {
        this.courseChange = new CourseChange(account, context, currentCourse, newCourse);
    }

    public void printCourseDockets() {
        if (this.courseChange != null) {
            this.getPrintAccount().printCourseIfNecessary(this.courseChange.currentCourse, this.courseChange.newCourse, this.courseChange.context, this.courseChange.account);
            this.courseChange = null;
        }
    }

    private boolean hasPendingOnlineOrders(Account account) {
        if (account instanceof BarTabAccount && account.isPersistent()) {
            int value;
            CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(OnlineOrderRetryWorker.class.getCanonicalName(), new CallMethod("getNumberOfPendingOrders", account.getID()));
            Object returned = PersistenceManager.getServerConnection().runSync(exec);
            if (returned instanceof Number && (value = ((Number)returned).intValue()) > 0) {
                this.getGui().displayOkDialog("Pending Online Orders", "This account has " + value + " pending online order" + (value > 1 ? "s" : ""));
                return true;
            }
        }
        return false;
    }

    private class CourseChange {
        protected final TableAccount account;
        protected final EventContext context;
        protected final Course currentCourse;
        protected final Course newCourse;

        CourseChange(TableAccount account, EventContext context, Course currentCourse, Course newCourse) {
            this.account = account;
            this.context = context;
            this.currentCourse = currentCourse;
            this.newCourse = newCourse;
        }
    }

    static enum AccountOperationType {
        CREATE,
        TRANSFER,
        UPDATE;

    }
}

