/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.persistence.Executable;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import org.apache.logging.log4j.Level;

public class ShiftChanger
extends Executable<Shift> {
    private Shift shift;

    public ShiftChanger(Shift shift) {
        this.shift = shift;
    }

    @Override
    public Shift execute() {
        try {
            OrderMate.LOG.info("Changing shift to " + this.shift);
            Terminal terminal = Terminal.getServerMateTerminal();
            terminal.changeShift(this.shift);
            terminal.save();
            Terminal.setupServerMate(terminal);
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.ERROR, "Error while changing shift to " + this.shift, (Throwable)ex);
        }
        return Terminal.getServerMateTerminal().getShift();
    }
}

