/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ShiftSelector
extends JPanel
implements ActionListener {
    public final Signal shift = Signals.createSignal(Shift.class, "newShift");
    private JButton nextButton;
    private JButton previousButton;
    private JLabel shiftLabel;
    private Shift currentShift;
    private ListIterator shiftIt;

    public ShiftSelector() {
        this.setLayout(new GraphPaperLayout(5, 1));
        this.previousButton = new JButton(IconLoader.get("/ordermate/images/leftarrow.png"));
        this.previousButton.setName("btn_prevShift");
        this.previousButton.addActionListener(this);
        this.add((Component)this.previousButton, new Rectangle(0, 0, 1, 1));
        this.shiftLabel = new JLabel();
        this.shiftLabel.setHorizontalAlignment(0);
        this.add((Component)this.shiftLabel, new Rectangle(1, 0, 3, 1));
        this.nextButton = new JButton(IconLoader.get("/ordermate/images/rightarrow.png"));
        this.nextButton.setName("btn_nextShift");
        this.nextButton.addActionListener(this);
        this.add((Component)this.nextButton, new Rectangle(4, 0, 1, 1));
    }

    public void setShifts(List shifts) {
        int indexOfCurrent = shifts.indexOf(Terminal.getLocalHost().getShift());
        if (indexOfCurrent == -1) {
            OrderMateLog.LOG.error("This terminal's shift: " + Terminal.getLocalHost().getShift().getLabel() + " cannot be found.");
            indexOfCurrent = shifts.size() - 1;
        }
        this.currentShift = (Shift)shifts.get(indexOfCurrent);
        this.shiftIt = shifts.listIterator(indexOfCurrent);
        this.displayShift();
    }

    public Shift getShift() {
        return this.currentShift;
    }

    public void setTextFont(Font toUse) {
        this.shiftLabel.setFont(toUse);
    }

    private void displayShift() {
        String shiftText = this.currentShift.getTradingDay().equals(TradingDay.getCurrentTradingDay()) ? "Today - " + this.currentShift.getName() : this.currentShift.getLabel();
        this.shiftLabel.setText(shiftText);
        this.previousButton.setEnabled(this.shiftIt.hasPrevious());
        this.nextButton.setEnabled(this.shiftIt.hasNext());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.previousButton) {
            Shift newShift = (Shift)this.shiftIt.previous();
            if (newShift == this.currentShift && this.shiftIt.hasPrevious()) {
                newShift = (Shift)this.shiftIt.previous();
            }
            this.currentShift = newShift;
            this.displayShift();
            this.shift.emit(this.currentShift);
        } else if (e.getSource() == this.nextButton) {
            Shift newShift = (Shift)this.shiftIt.next();
            if (newShift == this.currentShift && this.shiftIt.hasNext()) {
                newShift = (Shift)this.shiftIt.next();
            }
            this.currentShift = newShift;
            this.displayShift();
            this.shift.emit(this.currentShift);
        }
    }
}

