/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.persistence.PersistenceManager;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.VoucherPrintingStrategy;
import ordermate.database.queries.finance.voucher.VoucherQueries;
import ordermate.database.sales.Account;
import ordermate.docketprocessor.DocketProcessor;

class VoucherPrinting {
    private EventContext context;

    VoucherPrinting(EventContext yourContext) {
        this.context = yourContext;
    }

    public void printPrintClose(Account toClose) {
        List<GiftVoucherTransaction> txns = toClose.getActiveVoucherTxns();
        if (txns == null || txns.isEmpty()) {
            return;
        }
        LinkedHashSet<GiftVoucher> vouchers = new LinkedHashSet<GiftVoucher>();
        for (GiftVoucherTransaction txn : txns) {
            GiftVoucherConfiguration config = VoucherQueries.getConfigForVoucher(txn.getGiftVoucher());
            if (config == null) continue;
            VoucherPrintingStrategy strategy = config.getPrinting();
            switch (strategy) {
                case Never: {
                    break;
                }
                case Both: {
                    vouchers.add(txn.getGiftVoucher());
                    break;
                }
                case Redeem: {
                    if (!txn.isRedeeming()) break;
                    vouchers.add(txn.getGiftVoucher());
                    break;
                }
                case Topup: {
                    if (txn.isRedeeming()) break;
                    vouchers.add(txn.getGiftVoucher());
                }
            }
        }
        for (GiftVoucher voucher : vouchers) {
            try {
                DocketProcessor.printVoucher((GiftVoucher)PersistenceManager.reacquire(voucher), this.context);
            }
            catch (IOException ex) {
                OrderMate.LOG.warn("Cannot print out voucher", (Throwable)ex);
            }
        }
    }
}

