/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.autosuggestor;

import ca.odell.glazedlists.swing.AutoCompleteSupport;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import ordermate.OrderMate;
import ordermate.gui.autosuggestor.Suggestor;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DynamicSuggestionComboHandler
implements DocumentListener,
ActionListener,
PopupMenuListener {
    public Signal<Object, ?, ?, ?, ?> selectionMade = Signals.createSignal(Object.class, "objectSelected");
    private final JComboBox myCombo;
    private final CustomEditor myEditor;
    private final Suggestor mySuggestor;
    private final boolean autoComplete;
    private Object currentSelection = null;
    private boolean isUpdating = false;
    private String currentText;

    public <T> DynamicSuggestionComboHandler(Suggestor<T> suggestor, JComboBox box, boolean autoComplete) {
        this.mySuggestor = suggestor;
        if (autoComplete) {
            AutoCompleteSupport.install((JComboBox)box, suggestor.getSuggestions());
        }
        this.myCombo = box;
        box.setEditable(true);
        this.myEditor = new CustomEditor();
        box.setEditor(this.myEditor);
        if (!autoComplete) {
            box.addActionListener(this);
            box.addPopupMenuListener(this);
        }
        this.myEditor.getEditorComponent().getDocument().addDocumentListener(this);
        this.autoComplete = autoComplete;
    }

    public void update() {
        if (this.isUpdating) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DynamicSuggestionComboHandler.this.isUpdating = true;
                    JTextField field = DynamicSuggestionComboHandler.this.myEditor.getEditorComponent();
                    int start = field.getSelectionStart();
                    DynamicSuggestionComboHandler.this.currentText = field.getText(0, field.getSelectionStart());
                    DynamicSuggestionComboHandler.this.mySuggestor.setSuggestionCriteria(DynamicSuggestionComboHandler.this.currentText);
                    if (!DynamicSuggestionComboHandler.this.autoComplete && DynamicSuggestionComboHandler.this.myCombo.isShowing() && field.hasFocus()) {
                        if (DynamicSuggestionComboHandler.this.mySuggestor.hasSuggestions()) {
                            DynamicSuggestionComboHandler.this.myCombo.showPopup();
                        } else {
                            DynamicSuggestionComboHandler.this.myCombo.hidePopup();
                        }
                        field.setText(DynamicSuggestionComboHandler.this.currentText);
                        field.setSelectionStart(start);
                    }
                }
                catch (BadLocationException e) {
                    OrderMate.LOG.warn("Couldn't retrieve text.", (Throwable)e);
                }
                finally {
                    DynamicSuggestionComboHandler.this.isUpdating = false;
                }
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myCombo.getSelectedIndex() < 0) {
            this.currentText = this.myEditor.getEditorComponent().getText();
        } else {
            this.isUpdating = true;
            this.myEditor.getEditorComponent().setText(this.currentText);
        }
        this.isUpdating = false;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.myCombo.isVisible() && this.myEditor.getEditorComponent().hasFocus()) {
            this.isUpdating = true;
            if (this.myCombo.getSelectedIndex() == -1) {
                this.myEditor.getEditorComponent().setText(this.currentText);
            } else {
                this.currentSelection = this.myCombo.getSelectedItem();
                this.selectionMade.emit(this.currentSelection);
                this.currentText = this.myEditor.getEditorComponent().getText();
            }
            this.myCombo.hidePopup();
            this.isUpdating = false;
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    class CustomEditor
    implements ComboBoxEditor {
        private JTextField field = new JTextField();
        private String NULL = "Search...";

        @Override
        public JTextField getEditorComponent() {
            return this.field;
        }

        @Override
        public void setItem(Object anObject) {
            if (this.NULL.equals(anObject) || "".equals(anObject)) {
                this.field.setText(this.NULL);
                this.field.setForeground(Color.GRAY);
            } else {
                this.field.setText(anObject == null ? this.NULL : String.valueOf(anObject));
                this.field.setForeground(Color.BLACK);
            }
        }

        @Override
        public Object getItem() {
            String value = this.field.getText();
            if (this.NULL.equals(value)) {
                return null;
            }
            return value;
        }

        @Override
        public void selectAll() {
            this.field.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.field.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.field.removeActionListener(l);
        }
    }
}

