/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.autosuggestor;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.List;
import ordermate.gui.autosuggestor.Suggestor;

public abstract class LimitedSuggestor<P>
implements Suggestor<P> {
    private int limitResults;
    private int minChars;
    private String currentCriteria;
    private EventList suggestions;

    public LimitedSuggestor() {
        this(10, 1);
    }

    public LimitedSuggestor(int maxResults, int minimumCharsBeforeSearch) {
        this.limitResults = maxResults;
        this.minChars = minimumCharsBeforeSearch;
        this.currentCriteria = null;
        this.suggestions = this.makeList();
    }

    protected EventList<P> makeList() {
        return new BasicEventList();
    }

    @Override
    public EventList<P> getSuggestions() {
        return this.suggestions;
    }

    protected String getCurrentCriteria() {
        return this.currentCriteria;
    }

    @Override
    public void setSuggestionCriteria(String newCriteria) {
        if (newCriteria == null && this.currentCriteria == null) {
            return;
        }
        if (this.currentCriteria != null && this.currentCriteria.equals(newCriteria)) {
            return;
        }
        this.currentCriteria = newCriteria;
        if (this.currentCriteria == null || this.currentCriteria.length() < this.minChars) {
            this.suggestions.getReadWriteLock().writeLock().lock();
            this.suggestions.clear();
            this.suggestions.getReadWriteLock().writeLock().unlock();
        } else {
            List<P> updatedList = this.updateList(this.currentCriteria, this.limitResults);
            this.suggestions.getReadWriteLock().writeLock().lock();
            this.suggestions.clear();
            this.suggestions.addAll(updatedList);
            this.suggestions.getReadWriteLock().writeLock().lock();
        }
    }

    @Override
    public boolean hasSuggestions() {
        return !this.suggestions.isEmpty();
    }

    protected abstract List<P> updateList(String var1, int var2);
}

