/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.autosuggestor;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.PropertyValueSearcher;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.PrefixTextSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.SearchFilterI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.sales.Customer;
import ordermate.gui.autosuggestor.LimitedSuggestor;

public class StreetDirectorySearcherSuggestor<P extends PersistentObjectI>
extends LimitedSuggestor<String> {
    private final DefaultPropertySearcher<P> streetDirRefSearcher = new DefaultPropertySearcher<StreetDirectoryReference>(StreetDirectoryReference.class);
    private PropertyValueSearcher<String> salesCustomerSearcher;
    private PropertiedObject.Property salesCustomerTargetProp;
    private final PrefixTextSearchFilter target;

    public StreetDirectorySearcherSuggestor(PropertiedObject.Property theStreetDirRefTarget, PropertiedObject.Property<String> theStreetCustomerTarget) {
        this(theStreetDirRefTarget, theStreetCustomerTarget, 10, 2);
    }

    public StreetDirectorySearcherSuggestor(PropertiedObject.Property theStreetDirRefTarget, PropertiedObject.Property<String> theStreetCustomerTarget, int limitResults, int minChars) {
        super(limitResults, minChars);
        this.streetDirRefSearcher.setLimit(limitResults);
        this.target = new PrefixTextSearchFilter(theStreetDirRefTarget);
        this.streetDirRefSearcher.addSearchFilter(this.target);
        this.salesCustomerTargetProp = theStreetCustomerTarget;
        this.salesCustomerSearcher = new PropertyValueSearcher(this.salesCustomerTargetProp, null);
        this.salesCustomerSearcher.getObjectQuery().active(Customer.class);
    }

    public void addSearchFilter(SearchFilterI filter) {
        this.streetDirRefSearcher.addSearchFilter(filter);
    }

    public ObjectQuery getBaseQuery() {
        return this.streetDirRefSearcher.getBaseQuery();
    }

    public void setBaseQuery(ObjectQuery newQuery) {
        this.streetDirRefSearcher.setBaseQuery(newQuery);
    }

    @Override
    protected List<String> updateList(String criteria, int limitResults) {
        LinkedHashSet<Object> toReturn = new LinkedHashSet<Object>();
        this.target.setSearchValue(criteria);
        toReturn.addAll(PersistenceManager.getObjectList(this.streetDirRefSearcher));
        this.salesCustomerSearcher.updateSearchValue(criteria);
        this.salesCustomerSearcher.getObjectQuery().limit(limitResults);
        toReturn.addAll(this.salesCustomerSearcher.getMatches());
        return new ArrayList<String>(toReturn);
    }
}

