/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import ordermate.OrderMate;
import ordermate.gui.binding.ConversionException;
import org.apache.commons.beanutils.MethodUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class BindingHelper<T> {
    private Semaphore talkingStick = new Semaphore(1);
    private T boundObject;
    private Set<Binding<T, ?, ?, ?>> bindings = new HashSet();
    private AutoBinding.UpdateStrategy strategy;
    private Set<Binding> bindingNoSrcObject = new HashSet<Binding>();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean guiValid;
    private boolean bindPersistentPropertiesOnce = true;
    private final Set<PropertiedObject.Property> boundPersistentProperties = new HashSet<PropertiedObject.Property>();
    private Set<ObjectEditor> linkedObjectEditors = new HashSet<ObjectEditor>();

    public BindingHelper() {
        this.strategy = AutoBinding.UpdateStrategy.READ;
    }

    public BindingHelper(AutoBinding.UpdateStrategy newStrategy) {
        this.strategy = newStrategy;
    }

    public void setStrategy(AutoBinding.UpdateStrategy newStrategy) {
        this.strategy = newStrategy;
    }

    public AutoBinding.UpdateStrategy getStrategy() {
        return this.strategy;
    }

    public Binding createJComboBoxBinding(PropertiedObject.Property objectProperty, JComboBox target, List comboBoxData) {
        this.checkCanBindProperty(objectProperty);
        return this.createJComboBoxBinding((Property)BeanProperty.create((String)objectProperty.getName()), target, comboBoxData);
    }

    public Binding createJComboBoxBinding(Property objectProperty, JComboBox target, List comboBoxData) {
        JComboBoxBinding comboListBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)this.strategy, (List)comboBoxData, (JComboBox)target);
        this.bindingNoSrcObject.add((Binding)comboListBinding);
        return this.createBinding(objectProperty, (Object)target, "selectedItem");
    }

    public Binding createIntegerBinding(PropertiedObject.Property objectProperty, JSpinner spinner, int min, int max, int initialValue) {
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(initialValue, min, max, 1);
        spinner.setModel(spinnerModel);
        return this.createBinding(objectProperty, (Object)spinner, "value");
    }

    public Binding createBinding(PropertiedObject.Property objectProperty, Object target, String targetPropertyName) {
        this.checkCanBindProperty(objectProperty);
        return this.createBinding(objectProperty.getName(), target, targetPropertyName);
    }

    public Binding createBinding(String objectPropertyName, Object target, String targetPropertyName) {
        BeanProperty objectProperty = BeanProperty.create((String)objectPropertyName);
        return this.createBinding((Property)objectProperty, target, targetPropertyName);
    }

    public Binding createBinding(Property objectProperty, Object target, String targetPropertyName) {
        BeanProperty targetProperty = BeanProperty.create((String)targetPropertyName);
        return this.createBinding(objectProperty, target, (Property)targetProperty);
    }

    public Binding createBinding(Property objectProperty, Object target, Property targetProperty) {
        return this.createBinding(this.strategy, objectProperty, target, targetProperty);
    }

    public Binding createBinding(AutoBinding.UpdateStrategy updateStrategy, Property objectProperty, Object target, Property targetProperty) {
        AutoBinding toAdd = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)updateStrategy, null, (Property)objectProperty, (Object)target, (Property)targetProperty, (String)objectProperty.toString());
        this.addBinding((Binding)toAdd);
        return toAdd;
    }

    public void addBinding(final Binding toAdd) {
        this.bindings.add(toAdd);
        toAdd.getTargetProperty().addPropertyStateListener(toAdd.getTargetObject(), new PropertyStateListener(){

            public void propertyStateChanged(PropertyStateEvent arg0) {
                BindingHelper.this.runValidation(toAdd);
            }
        });
    }

    public void removeBinding(PropertiedObject.Property prop, Binding toRemove) {
        PropertyStateListener[] listeners;
        this.bindings.remove(toRemove);
        if (toRemove.isBound()) {
            toRemove.unbind();
        }
        if ((listeners = toRemove.getTargetProperty().getPropertyStateListeners(toRemove.getTargetObject())).length > 0) {
            toRemove.getTargetProperty().removePropertyStateListener(toRemove.getTargetObject(), listeners[listeners.length - 1]);
        }
        this.boundPersistentProperties.remove(prop);
    }

    public T getObject() {
        return this.boundObject;
    }

    public boolean isGuiValid() {
        if (this.talkingStick.availablePermits() > 0) {
            for (Binding<T, ?, ?, ?> toCheck : this.bindings) {
                if (this.runValidation(toCheck)) continue;
                this.guiValid = false;
                OrderMate.LOG.debug("Gui is not valid");
                return this.guiValid;
            }
            this.guiValid = true;
            return this.guiValid;
        }
        OrderMate.LOG.debug("GUI is busy. Returning last known result.");
        return this.guiValid;
    }

    public void addValidatedAction(final Action action) {
        this.addPropertyChangeListener("guiValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                action.setEnabled(BindingHelper.this.isGuiValid());
            }
        });
    }

    public void bridgePropertyValid(final JComponent objectEditor) {
        this.addPropertyChangeListener("guiValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    MethodUtils.invokeMethod((Object)objectEditor, (String)"firePropertyChange", (Object[])new Object[]{"guiValid", evt.getOldValue(), evt.getNewValue()});
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invoking method 'firePropertyChange'", e);
                }
            }
        });
    }

    private boolean runValidation(Binding toValidate) {
        Binding.ValueResult result = toValidate.getTargetValueForSource();
        if (result.failed()) {
            if (toValidate.getTargetObject() instanceof JComponent) {
                JComponent toSetup = (JComponent)toValidate.getTargetObject();
                if (!toSetup.isEnabled()) {
                    this.validateComponent(toSetup, true);
                    return true;
                }
                this.showErrorDescription(result, toSetup);
                this.validateComponent(toSetup, false);
            }
            return false;
        }
        if (toValidate.getTargetObject() instanceof JComponent) {
            JComponent toSetup = (JComponent)toValidate.getTargetObject();
            this.validateComponent(toSetup, true);
        }
        return true;
    }

    private void validateComponent(JComponent toSetup, boolean valid) {
        if (valid) {
            this.hideErrorDescription(toSetup);
            if (toSetup.getClientProperty("invalid") != null) {
                toSetup.setBackground((Color)toSetup.getClientProperty("validColor"));
                toSetup.putClientProperty("validColor", null);
                toSetup.putClientProperty("invalid", null);
                this.pcs.firePropertyChange("guiValid", false, true);
            }
        } else if (toSetup.getClientProperty("invalid") == null) {
            toSetup.putClientProperty("validColor", toSetup.getBackground());
            toSetup.setBackground(new Color(255, 255, 100));
            toSetup.putClientProperty("invalid", Boolean.TRUE);
            this.pcs.firePropertyChange("guiValid", true, false);
        }
    }

    private void hideErrorDescription(JComponent toSetup) {
        toSetup.setToolTipText((String)toSetup.getClientProperty("validTooltip"));
        Action toolTipAction = toSetup.getActionMap().get("hideTip");
        if (toolTipAction != null) {
            ActionEvent postTip = new ActionEvent(toSetup, 1001, "");
            toolTipAction.actionPerformed(postTip);
        }
        toSetup.putClientProperty("validTooltip", null);
    }

    private void showErrorDescription(Binding.ValueResult result, JComponent toSetup) {
        if (toSetup.getClientProperty("validTooltip") == null) {
            toSetup.putClientProperty("validTooltip", toSetup.getToolTipText());
        }
        String text = null;
        if (result.getFailure().getType().equals((Object)Binding.SyncFailureType.VALIDATION_FAILED)) {
            text = result.getFailure().getValidationResult().getDescription();
        }
        if (result.getFailure().getType().equals((Object)Binding.SyncFailureType.CONVERSION_FAILED)) {
            RuntimeException theException = result.getFailure().getConversionException();
            if (theException instanceof NumberFormatException) {
                text = "Incorrect value for a number.";
            } else if (theException instanceof ConversionException) {
                text = theException.getMessage();
            }
        }
        if (text != null && text != toSetup.getToolTipText()) {
            Action toolTipAction;
            toSetup.setToolTipText(text);
            if (toSetup.getClientProperty("invalid") == null && (toolTipAction = toSetup.getActionMap().get("postTip")) != null) {
                ActionEvent postTip = new ActionEvent(toSetup, 1001, "");
                toolTipAction.actionPerformed(postTip);
            }
        }
    }

    public void saveObject() {
        Iterator<Binding<T, ?, ?, ?>> it = this.bindings.iterator();
        AutoBinding.UpdateStrategy bindingStrategy = AutoBinding.UpdateStrategy.READ_WRITE;
        while (it.hasNext()) {
            Binding.SyncFailure failure;
            Binding<T, ?, ?, ?> toSave = it.next();
            if (toSave instanceof AutoBinding) {
                bindingStrategy = ((AutoBinding)toSave).getUpdateStrategy();
            }
            if (!toSave.isBound() || toSave.getTargetValueForSource().failed() || (failure = toSave.save()) == null) continue;
            throw new RuntimeException("Could not save binding : " + toSave + " due to " + failure + " using binding strategy:" + bindingStrategy);
        }
        for (ObjectEditor objectEditor : this.linkedObjectEditors) {
            objectEditor.saveObject();
        }
    }

    public void setObject(T toEdit) {
        try {
            this.talkingStick.acquire();
            this.pcs.firePropertyChange("guiValid", true, false);
            T old = this.boundObject;
            this.boundObject = toEdit;
            this.unbind();
            for (Binding binding : this.bindingNoSrcObject) {
                binding.bind();
            }
            for (Binding binding : this.bindings) {
                binding.setSourceObject(toEdit);
                binding.bind();
                this.runValidation(binding);
            }
            this.talkingStick.release();
            this.pcs.firePropertyChange("object", old, this.boundObject);
            this.pcs.firePropertyChange("guiValid", false, true);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't set the object on the editor ", (Throwable)ex);
        }
    }

    private void unbind() {
        for (Binding binding : this.bindingNoSrcObject) {
            if (!binding.isBound()) continue;
            binding.unbind();
        }
        for (Binding binding : this.bindings) {
            if (!binding.isBound()) continue;
            binding.unbind();
        }
    }

    public void clear() {
        this.unbind();
        this.bindingNoSrcObject.clear();
        this.bindings.clear();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void setBindPersistentPropertiesOnce(boolean setIt) {
        this.bindPersistentPropertiesOnce = setIt;
    }

    private void checkCanBindProperty(PropertiedObject.Property prop) {
        if (this.bindPersistentPropertiesOnce && this.boundPersistentProperties.contains(prop)) {
            IllegalArgumentException ex = new IllegalArgumentException("Property :" + prop + " is already bound");
            if (Config.isConfigSetup() && Config.isDebuging()) {
                throw ex;
            }
            OrderMate.LOG.error("Property is already bound, possible programming error", (Throwable)ex);
        }
        this.boundPersistentProperties.add(prop);
    }

    public void addLinkedObjectEditors(ObjectEditor linkedEditor) {
        this.linkedObjectEditors.add(linkedEditor);
    }

    public boolean removeLinkedObjectEditors(ObjectEditor linkedEditor) {
        return this.linkedObjectEditors.remove(linkedEditor);
    }

    public Set<Binding<T, ?, ?, ?>> getAllBindings() {
        return Collections.unmodifiableSet(this.bindings);
    }

    public Binding findBinding(PropertiedObject.Property property) {
        for (Binding<T, ?, ?, ?> binding : this.bindings) {
            if (!binding.getSourceProperty().toString().contains(property.getName())) continue;
            return binding;
        }
        return null;
    }

    public void setBindEnabled(boolean toBindOrNotToBind, Binding binding, PropertiedObject.Property property) {
        if (toBindOrNotToBind && !this.bindings.contains(binding)) {
            binding.bind();
            this.addBinding(binding);
        } else if (!toBindOrNotToBind && this.bindings.contains(binding)) {
            this.removeBinding(property, binding);
        }
    }
}

