/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import ordermate.gui.binding.BindingHelper;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ColumnVisibilityHelper
implements ActionListener {
    private final Object[] columns;
    private final JCheckBox box;
    private final Set<JXTable> tableSet = new HashSet<JXTable>();
    private final BindingHelper bindings = new BindingHelper();

    public ColumnVisibilityHelper(Object[] columnIdentifiers, JCheckBox checkBox, JXTable theTable) {
        this.columns = columnIdentifiers;
        this.box = checkBox;
        this.addTable(theTable);
    }

    public void addTable(JXTable table) {
        if (this.tableSet.add(table)) {
            this.bind(table);
        }
    }

    public JCheckBox getCheckBox() {
        return this.box;
    }

    private void bind(JXTable table) {
        BeanProperty selectedProp = BeanProperty.create((String)"selected");
        for (int i = 0; i < this.columns.length; ++i) {
            TableColumnExt column = table.getColumnExt(this.columns[i]);
            if (column == null) {
                throw new IllegalStateException("table should have column corresponding to : " + this.columns[i]);
            }
            this.bindings.createBinding((Property)selectedProp, (Object)column, (Property)BeanProperty.create((String)"visible"));
        }
        this.bindings.setObject(this.box);
        this.box.addActionListener(this);
    }

    public void unbind() {
        this.box.removeActionListener(this);
        this.bindings.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (JXTable table : this.tableSet) {
            table.packAll();
        }
    }

    public boolean isVisible() {
        return this.box.isSelected();
    }
}

