/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.converter;

import au.com.ordermate.util.Price;
import ordermate.database.finance.Denomination;
import org.jdesktop.beansbinding.Converter;

public class DenominationNumToPriceTotalConverter
extends Converter {
    private Denomination denom;

    public DenominationNumToPriceTotalConverter(Denomination denomination) {
        this.denom = denomination;
    }

    public Object convertForward(Object arg0) {
        try {
            int num = Integer.parseInt(arg0.toString());
            return new Price((double)num * this.denom.getValue(), 0.01).toString();
        }
        catch (NumberFormatException ex) {
            return Price.ZERO.toString();
        }
    }

    public Object convertReverse(Object arg0) {
        try {
            Price total = Price.parsePrice(arg0.toString(), 0.01);
            return new Integer(Math.round((float)(total.doubleValue() / this.denom.getValue()))).toString();
        }
        catch (NumberFormatException ex) {
            return "0";
        }
    }

    public static class Inverse
    extends Converter {
        private Denomination denom;

        public Inverse(Denomination denomination) {
            this.denom = denomination;
        }

        public Object convertReverse(Object arg0) {
            try {
                int num = Integer.parseInt(arg0.toString());
                return new Price((double)num * this.denom.getValue(), 0.01);
            }
            catch (NumberFormatException ex) {
                return Price.ZERO;
            }
        }

        public Object convertForward(Object arg0) {
            Price total = (Price)arg0;
            return new Integer(Math.round((float)(total.doubleValue() / this.denom.getValue()))).toString();
        }
    }
}

