/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.converter;

import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.finance.Denomination;
import org.jdesktop.beansbinding.Converter;

public class TotalToUnitDenominationConverter
extends Converter {
    private Denomination denomination;

    public TotalToUnitDenominationConverter(Denomination denom) {
        this.denomination = denom;
    }

    public Object convertReverse(Object totalField) {
        String retValue = "0";
        if (!totalField.toString().isEmpty()) {
            try {
                Price total = Price.parsePrice(totalField.toString(), 0.01);
                int qty = (int)Math.round(total.doubleValue() / this.denomination.getValue());
                Price reverse = new Price((double)qty * this.denomination.getValue(), 0.01);
                retValue = !total.equals(reverse) ? "########" : new Integer(qty).toString();
            }
            catch (NumberFormatException nfe) {
                OrderMate.LOG.error("Cannot convert from price to a number:", (Throwable)nfe);
                retValue = "########";
            }
        }
        return retValue;
    }

    public Object convertForward(Object unitField) {
        if (!unitField.toString().isEmpty()) {
            try {
                int num = Integer.parseInt(unitField.toString());
                return new Price((double)num * this.denomination.getValue(), 0.01).toString();
            }
            catch (NumberFormatException nfe) {
                OrderMate.LOG.error("Cannot convert from a number to a price:", (Throwable)nfe);
                return "########";
            }
        }
        return new Price(0.0, 0.01).toString();
    }
}

