/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.validators;

import au.com.ordermate.util.Price;
import ordermate.database.finance.Denomination;
import org.jdesktop.beansbinding.Validator;

public class DenominationValidator
extends Validator {
    private Denomination denomination;

    public DenominationValidator(Denomination denom) {
        this.denomination = denom;
    }

    public Validator.Result validate(Object price) {
        long qty;
        Price reverse;
        Price total = (Price)price;
        if (total.getRoundAmount() == 0.0) {
            throw new IllegalArgumentException("Price's should have a round amount other than zero");
        }
        Validator.Result result = null;
        if (!(price instanceof Price)) {
            result = new Validator.Result((Validator)this, price, "Invalid value to validate " + price.getClass().getName());
        }
        if (!total.equals(reverse = new Price((double)(qty = Math.round(total.doubleValue() / this.denomination.getValue())) * this.denomination.getValue(), 0.01))) {
            result = new Validator.Result((Validator)this, (Object)total, "Invalid total for this denomination :" + this.denomination.getLabel());
        }
        return result;
    }
}

