/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.validators;

import au.com.ordermate.util.StringUtils;
import java.util.regex.Pattern;
import ordermate.database.users.User;
import org.jdesktop.beansbinding.Validator;

public class EmailValidator
extends Validator<String> {
    private User currentUser;
    private static final String REGEX = "[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";

    public Validator.Result validate(String email) {
        Pattern pattern = Pattern.compile(REGEX);
        if (StringUtils.isEmpty(email)) {
            return new Validator.Result((Validator)this, (Object)email, "Email cannot be empty!");
        }
        if (!pattern.matcher(email).matches()) {
            return new Validator.Result((Validator)this, (Object)email, "Email format is incorrect");
        }
        User user = User.getUserByEmail(email);
        if (user != null && this.currentUser != null && !this.currentUser.equals(user)) {
            return new Validator.Result((Validator)this, (Object)email, "This email is already used!");
        }
        return null;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }
}

