/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.validators;

import java.io.File;
import org.jdesktop.beansbinding.Validator;

public class FileExistsValidator
extends Validator {
    private boolean allowDirectory;
    private boolean allowFile;
    private boolean allowEmpty;
    private String prefix;

    public FileExistsValidator() {
        this(true, true);
    }

    public FileExistsValidator setAllowEmpty(boolean allowIt) {
        this.allowEmpty = allowIt;
        return this;
    }

    public FileExistsValidator(boolean allowDirectories, boolean allowFiles) {
        this(allowDirectories, allowFiles, null);
    }

    public FileExistsValidator(boolean allowDirectories, boolean allowFiles, String toPrepend) {
        this.allowDirectory = allowDirectories;
        this.allowFile = allowFiles;
        this.prefix = toPrepend;
    }

    public Validator.Result validate(Object arg0) {
        File file;
        if (arg0 == null) {
            if (this.allowEmpty) {
                return null;
            }
            return new Validator.Result((Validator)this, null, "Null file does not exist");
        }
        if (arg0 instanceof File) {
            file = (File)arg0;
        } else {
            if (this.allowEmpty && arg0.toString().trim().equals("")) {
                return null;
            }
            String path = this.prefix != null ? this.prefix + arg0.toString() : arg0.toString();
            file = new File(path);
        }
        if (file.exists()) {
            if (this.allowDirectory && file.isDirectory() || this.allowFile && file.isFile()) {
                return null;
            }
            return new Validator.Result((Validator)this, arg0, "File exists but is not of an allowed type");
        }
        if (arg0.getClass().getResourceAsStream(arg0.toString()) != null) {
            return null;
        }
        if (this.prefix != null) {
            return new Validator.Result((Validator)this, arg0, "File or directory does not exist on " + this.prefix);
        }
        return new Validator.Result((Validator)this, arg0, "File does not exist");
    }
}

