/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.validators;

import java.util.StringTokenizer;
import org.jdesktop.beansbinding.Validator;

public class InetAddressValidator
extends Validator {
    private boolean emptyAllowed = false;
    private boolean localHostAllowed = false;

    public InetAddressValidator() {
    }

    public InetAddressValidator(boolean allowEmpty) {
        this();
        this.emptyAllowed = allowEmpty;
    }

    public InetAddressValidator(boolean allowEmpty, boolean allowLocalHost) {
        this(allowEmpty);
        this.localHostAllowed = allowLocalHost;
    }

    public Validator.Result validate(Object arg0) {
        String address = (String)arg0;
        if (this.emptyAllowed && (address == null || address.isEmpty())) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(address, ".");
        if (tokens.countTokens() != 4) {
            if (!this.localHostAllowed || this.localHostAllowed && !address.equals("localhost")) {
                return new Validator.Result((Validator)this, null, "Invalid IP Address");
            }
        } else {
            if (address.equals("0.0.0.0") && !this.localHostAllowed) {
                return new Validator.Result((Validator)this, null, "Invalid IP Address");
            }
            if (address.equals("0.0.0.0") && this.localHostAllowed) {
                return null;
            }
            try {
                boolean first = true;
                while (tokens.hasMoreTokens()) {
                    String octet = tokens.nextToken();
                    int oct = Integer.parseInt(octet);
                    if (!this.checkOctet(oct, first)) {
                        return new Validator.Result((Validator)this, null, "Invalid IP Address");
                    }
                    first = false;
                }
            }
            catch (Exception e) {
                return new Validator.Result((Validator)this, null, "Invalid IP Address");
            }
        }
        return null;
    }

    private boolean checkOctet(int octet, boolean first) {
        return !(first ? octet < 1 || octet > 255 : octet < 0 || octet > 255);
    }

    public boolean isLocalHostAllowed() {
        return this.localHostAllowed;
    }

    public void setLocalHostAllowed(boolean allowed) {
        this.localHostAllowed = allowed;
    }

    public boolean isEmptyAddressAllowed() {
        return this.emptyAllowed;
    }

    public void setEmptyAddressAllowed(boolean allowed) {
        this.emptyAllowed = allowed;
    }
}

