/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.validators;

import au.com.ordermate.util.Price;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.beansbinding.Validator;

public class NumericalValidator<T extends Number>
extends Validator {
    private static final Map<Class<? extends Number>, NumberValueOf> valueOfCache = new HashMap<Class<? extends Number>, NumberValueOf>(){
        {
            this.put(Double.class, new NumberValueOf<Double>(){

                @Override
                public Double valueOf(String toParse) {
                    return Double.valueOf(toParse);
                }
            });
            this.put(Long.class, new NumberValueOf<Long>(){

                @Override
                public Long valueOf(String toParse) {
                    return Long.valueOf(toParse);
                }
            });
            this.put(Integer.class, new NumberValueOf<Integer>(){

                @Override
                public Integer valueOf(String toParse) {
                    return Integer.valueOf(toParse);
                }
            });
        }
    };
    private T min;
    private T max;
    private Class clazz;

    public NumericalValidator(T newMin, T newMax, Class<T> clazz) {
        this.clazz = clazz;
        this.min = newMin;
        this.max = newMax;
    }

    public Validator.Result validate(Object arg0) {
        if (arg0 == null || arg0.toString().trim().isEmpty()) {
            return null;
        }
        Validator.Result res = null;
        Price value = null;
        try {
            value = (Price)this.valueOf(arg0.toString(), this.clazz);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value == null) {
            try {
                value = Price.parsePrice(arg0.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value == null) {
            res = new Validator.Result((Validator)this, arg0, "Value is not a valid number.");
        } else {
            if (this.min != null && ((Number)value).doubleValue() < ((Number)this.min).doubleValue()) {
                res = new Validator.Result((Validator)this, arg0, "Value is less than the minimum:" + this.min.toString());
            }
            if (res == null && this.max != null && ((Number)value).doubleValue() > ((Number)this.max).doubleValue()) {
                res = new Validator.Result((Validator)this, arg0, "Value is greater than the maximum:" + this.max.toString());
            }
        }
        return res;
    }

    private T valueOf(String toParse, Class<T> newclazz) {
        NumberValueOf toCall = valueOfCache.get(newclazz);
        if (toCall == null) {
            throw new IllegalStateException("Unknown Number type - add the type to the valueOfCache in NumericalValidator");
        }
        return toCall.valueOf(toParse);
    }

    static interface NumberValueOf<T extends Number> {
        public T valueOf(String var1);
    }
}

