/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.validators;

import java.util.List;
import ordermate.database.users.User;
import org.jdesktop.beansbinding.Validator;

public class PinValidator
extends Validator {
    private int minLength = 1;
    private User currentUser;

    public void setMinLength(int value) {
        this.minLength = value;
    }

    public Validator.Result validate(Object pin) {
        Validator.Result retValue = null;
        if (pin.toString().trim().equalsIgnoreCase("")) {
            return null;
        }
        try {
            Integer.parseInt(pin.toString());
        }
        catch (NumberFormatException ex) {
            retValue = new Validator.Result((Validator)this, pin, "This PIN is not valid, a Pin must be a number");
        }
        List<User> users = User.getUsers();
        for (User user : users) {
            if (user == null || user.getPin() == null || !user.getPin().equals(pin) || this.currentUser.equals(user)) continue;
            retValue = new Validator.Result((Validator)this, (Object)user, "This PIN is not valid, please enter a different pin.");
        }
        if (pin.toString().trim().length() < this.minLength) {
            retValue = new Validator.Result((Validator)this, pin, "This PIN is not long enough. Minimum length:" + this.minLength);
        }
        return retValue;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }
}

