/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.binding.validators;

import org.jdesktop.beansbinding.Validator;

public class PositiveIntValidator
extends Validator {
    private final boolean allowZero;
    private final boolean allowEmpty;

    public PositiveIntValidator() {
        this(true, false);
    }

    public PositiveIntValidator(boolean acceptZero) {
        this(acceptZero, false);
    }

    public PositiveIntValidator(boolean acceptZero, boolean acceptEmpty) {
        this.allowZero = acceptZero;
        this.allowEmpty = acceptEmpty;
    }

    public Validator.Result validate(Object arg0) {
        try {
            if (this.allowEmpty && (arg0 == null || arg0.toString().trim().isEmpty())) {
                return null;
            }
            if (!this.allowEmpty && arg0 == null) {
                return new Validator.Result((Validator)this, null, "");
            }
            int i = Integer.parseInt(arg0 + "");
            if (i > 0) {
                return null;
            }
            if (this.allowZero && i == 0) {
                return null;
            }
            if (i == 0) {
                return new Validator.Result((Validator)this, arg0, "Zero is not valid for this validator");
            }
            return new Validator.Result((Validator)this, arg0, "Negative numbers are not valid.");
        }
        catch (NumberFormatException ex) {
            return new Validator.Result((Validator)this, arg0, "Argument was not a number");
        }
    }
}

