/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.breadcrumb;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import ordermate.gui.button.CustomButton;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class Breadcrumb<T extends TreeNode & Displayable>
extends JPanel
implements ActionListener {
    private static final String DEFAULT_ROOT_STRING = "Home";
    private static final String DEFAULT_HIDDEN_TERMS_STRING = "...";
    private static final String DEFAULT_TREE_NODE_ARROW = ">";
    private static final int DEFAULT_HEIGHT = 40;
    public final Signal<T, ?, ?, ?, ?> breadcrumbSelected = Signals.createSignal(this.getGenericClass(), "selected");
    private int numberNodes;
    private boolean alwaysShowRoot;
    private boolean rootIsNullParent;
    private List<BreadcrumbPair<CustomButton<T>, JLabel>> nodeButtonGroup;
    private BreadcrumbPair<CustomButton<T>, JLabel> nullRootButton;
    private JLabel endObjectLabel;

    public Breadcrumb() {
        this(4, true, true);
    }

    private Breadcrumb(int numNodes, boolean alwaysShowRoot, boolean rootIsNullParent) {
        this.numberNodes = numNodes;
        this.alwaysShowRoot = alwaysShowRoot;
        this.rootIsNullParent = rootIsNullParent;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new BoxLayout(this, 0));
        if (this.rootIsNullParent) {
            this.nullRootButton = this.buildBreadcrumbPair(DEFAULT_HIDDEN_TERMS_STRING);
            this.nullRootButton.setData(null);
            this.addPairToPanel(this.nullRootButton);
        }
        this.nodeButtonGroup = new ArrayList<BreadcrumbPair<CustomButton<T>, JLabel>>();
        for (int i = 0; i < this.numberNodes; ++i) {
            BreadcrumbPair<CustomButton<T>, JLabel> toAdd = this.buildBreadcrumbPair();
            this.addPairToPanel(toAdd);
            this.nodeButtonGroup.add(toAdd);
        }
        this.endObjectLabel = this.buildJLabel("");
        this.add(this.endObjectLabel);
        this.setPreferredSize(new Dimension(99999, 40));
    }

    private void addPairToPanel(BreadcrumbPair<CustomButton<T>, JLabel> toAdd) {
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(toAdd.getSeperator());
        panel.setMinimumSize(new Dimension(0, 0));
        panel.setPreferredSize(new Dimension(20, 40));
        panel.setMaximumSize(new Dimension(20, 40));
        this.add(toAdd.getButton());
        this.add(panel);
    }

    public void setObject(T obj) {
        this.setAllVisible(false);
        boolean hiddenNodes = false;
        if (obj != null) {
            List<T> objParents = this.getAllParents(obj);
            List<T> objSubList = this.doSubList(objParents, this.numberNodes);
            hiddenNodes = objParents.size() > objSubList.size();
            this.endObjectLabel.setText(((Displayable)obj).getLabel());
            this.updatePanel(objSubList, hiddenNodes);
        } else {
            this.endObjectLabel.setText(this.getRootString());
        }
    }

    private void setAllVisible(boolean toSet) {
        this.nullRootButton.setVisible(toSet);
        for (BreadcrumbPair<CustomButton<T>, JLabel> pair : this.nodeButtonGroup) {
            pair.setVisible(toSet);
        }
    }

    private void updatePanel(List<T> objSubList, boolean hasHiddenButtons) {
        this.nullRootButton.setVisible(true);
        this.nullRootButton.setSeperatorText(hasHiddenButtons ? DEFAULT_HIDDEN_TERMS_STRING : DEFAULT_TREE_NODE_ARROW);
        for (int i = 0; i < this.numberNodes; ++i) {
            if (i >= objSubList.size()) continue;
            BreadcrumbPair<CustomButton<TreeNode>, JLabel> pair = this.nodeButtonGroup.get(i);
            pair.setData((TreeNode)objSubList.get(i));
            pair.setVisible(true);
        }
    }

    private BreadcrumbPair<CustomButton<T>, JLabel> buildBreadcrumbPair() {
        return this.buildBreadcrumbPair(DEFAULT_TREE_NODE_ARROW);
    }

    private BreadcrumbPair<CustomButton<T>, JLabel> buildBreadcrumbPair(String text) {
        BreadcrumbPair pair = new BreadcrumbPair(this, this.buildCustomButton(), this.buildJLabel(text));
        return pair;
    }

    private JLabel buildJLabel(String text) {
        JLabel toReturn = new JLabel(text);
        toReturn.setFont(OrderMateTheme.getMediumFont());
        return toReturn;
    }

    private CustomButton<T> buildCustomButton() {
        CustomButton custButton = new CustomButton();
        custButton.setMinimumSize(new Dimension(0, 0));
        custButton.setPreferredSize(new Dimension(100, 40));
        custButton.setMaximumSize(new Dimension(100, 40));
        custButton.addActionListener(this);
        return custButton;
    }

    List<T> doSubList(List<T> objParents, int numOfBreadCrumbs) {
        if (objParents.isEmpty()) {
            return objParents;
        }
        int startIndex = objParents.size() - numOfBreadCrumbs;
        startIndex = startIndex < 0 ? 0 : startIndex;
        int endIndex = objParents.size();
        return objParents.subList(startIndex, endIndex);
    }

    private List<T> getAllParents(T obj) {
        ArrayList<T> toReturn = new ArrayList<T>();
        if (obj == null) {
            return toReturn;
        }
        Object currParent = obj;
        do {
            toReturn.add(currParent);
        } while ((currParent = currParent.getParent()) != null);
        Collections.reverse(toReturn);
        toReturn.remove(obj);
        return toReturn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof CustomButton) {
            this.breadcrumbSelected.emit(((CustomButton)source).getData());
        }
    }

    protected String getRootString() {
        return DEFAULT_ROOT_STRING;
    }

    public abstract Class<T> getGenericClass();

    private static class BreadcrumbPair<B extends CustomButton<T>, L extends JLabel> {
        B customButton;
        L serperatorLabel;
        final /* synthetic */ Breadcrumb this$0;

        public BreadcrumbPair(B custButt, L sepLab) {
            this.this$0 = var1_1;
            this.customButton = custButt;
            this.serperatorLabel = sepLab;
        }

        public B getButton() {
            return this.customButton;
        }

        public L getSeperator() {
            return this.serperatorLabel;
        }

        public void setVisible(boolean bool) {
            ((JComponent)this.customButton).setVisible(bool);
            ((JComponent)this.serperatorLabel).setVisible(bool);
            ((Component)this.serperatorLabel).getParent().setVisible(bool);
        }

        public void setData(T toSet) {
            ((CustomButton)this.customButton).setData((Displayable)((Displayable)toSet));
            if (toSet == null) {
                ((AbstractButton)this.customButton).setText(this.this$0.getRootString());
            }
        }

        public void setSeperatorText(String text) {
            ((JLabel)this.serperatorLabel).setText(text);
        }
    }
}

