/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.breadcrumb;

import au.com.ordermate.persistence.Displayable;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;

public abstract class ChildTreeNodeScrollPane<T extends TreeNode & Displayable>
extends JPanel {
    private int numToDisplay;
    private RendererScrollPaneModel<T> model;
    private CustomScrollPane scroll;
    private Renderer renderer;
    private T localObject;
    private Dimension prefSize;

    public ChildTreeNodeScrollPane(int numToDisplay, Renderer objRenderer) {
        this.numToDisplay = numToDisplay;
        this.renderer = objRenderer;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.model = new RendererScrollPaneModel(this.renderer);
        this.model.setColumns(1);
        this.model.setRowsPerPage(this.numToDisplay);
        this.scroll = new CustomScrollPane(this.model);
        this.scroll.setName("stockAreaSelectChild");
        this.add(this.scroll);
    }

    public void setObject(T toSet) {
        this.localObject = toSet;
        this.updatePanel();
    }

    private void updatePanel() {
        List<T> childList = this.getChildList();
        this.model.setObjects(childList);
        if (this.getSize().width > 0) {
            this.prefSize = this.getSize();
            this.setPreferredSize(this.prefSize);
        }
    }

    private List<T> getChildList() {
        List<Object> childList = new ArrayList();
        if (this.localObject != null) {
            Enumeration<? extends TreeNode> ofChildern = this.localObject.children();
            while (ofChildern.hasMoreElements()) {
                childList.add(ofChildern.nextElement());
            }
        } else {
            childList = this.getTopLevelObjects();
        }
        return childList;
    }

    public abstract List<T> getTopLevelObjects();
}

