/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.button;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import ordermate.OrderMate;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.button.CustomButtonLabelGenerator;
import ordermate.gui.button.CustomButtonRenderer;

public class CustomButton<T extends Displayable>
extends JButton {
    private static final int BUTTON_MIN_SIZE = 60;
    private T information;
    private boolean showIcon = true;
    private boolean showBackgroundColor = true;
    private String trueName = null;
    private boolean showIconOnly = false;
    private CustomButtonLabelGenerator<T> customLabelGenerator = null;

    public CustomButton() {
        this.init();
        this.setRolloverEnabled(false);
    }

    public CustomButton(T info) {
        this(info, null);
    }

    public CustomButton(T info, CustomButtonLabelGenerator<T> customLabelGenerator) {
        this();
        this.customLabelGenerator = customLabelGenerator;
        this.setData(info);
    }

    private void init() {
        Dimension max = this.getMaximumSize();
        if (max.height < 60) {
            max.height = 60;
        }
        if (max.width < 60) {
            max.width = 60;
        }
        this.setMaximumSize(max);
        Dimension preferred = this.getPreferredSize();
        if (preferred.height < 60) {
            preferred.height = 60;
        }
        if (preferred.width < 60) {
            preferred.width = 60;
        }
        this.setPreferredSize(preferred);
        this.setMinimumSize(new Dimension(60, 60));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
                CustomButton.this.doClick();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }
        });
    }

    public void setInfo(T info) {
        this.information = info;
    }

    public void setData(T info) {
        String label;
        block11: {
            this.information = info;
            if (info == null) {
                this.clearData();
                return;
            }
            Color fgColor = info.getForegroundColor();
            Color bgColor = info.getBackgroundColor();
            if (!this.showBackgroundColor) {
                bgColor = null;
            }
            OrderMateThemeI.Helper.setButtonColour(this, fgColor, bgColor);
            if (this.showIcon && info.getIcon() != null) {
                String icon = info.getIcon();
                try {
                    if (!icon.equalsIgnoreCase("")) {
                        this.setIcon(IconLoader.get(icon));
                    }
                }
                catch (IconLoader.IconNotFoundException e) {
                    if (e.getCause() != null) {
                        OrderMate.LOG.warn("Expected image not found : " + icon + " " + e.getCause().getStackTrace()[0] + " , " + e.getCause().getStackTrace()[1] + ", " + e.getCause().getStackTrace()[2]);
                        break block11;
                    }
                    OrderMate.LOG.warn("Expected image not found : " + icon + " " + e.getStackTrace()[0] + " , " + e.getStackTrace()[1] + ", " + e.getStackTrace()[2]);
                }
            } else {
                this.setIcon(null);
            }
        }
        String string = label = this.customLabelGenerator != null ? this.customLabelGenerator.getLabelText(info) : info.getLabel();
        if (!(label == null || this.showIconOnly && this.getIcon() != null)) {
            this.setText(label);
        } else {
            this.setText("");
        }
        if (this.getTrueName() == null) {
            Class<?> displayType = info.getClass();
            String name = displayType.getName();
            super.setName(name);
        }
    }

    @Override
    public void setName(String toSet) {
        super.setName(toSet);
        this.trueName = toSet;
    }

    private String getTrueName() {
        return this.trueName;
    }

    public T getData() {
        if (this.information instanceof CustomButtonRenderer) {
            return ((CustomButtonRenderer)this.information).getData();
        }
        return this.information;
    }

    @Override
    public String toString() {
        return this.getText();
    }

    public void showIcon(boolean showIt) {
        this.showIcon = showIt;
        if (!this.showIcon) {
            this.setIcon(null);
        }
    }

    public void setShowIconOnly(boolean only) {
        this.showIconOnly = only;
    }

    public boolean getShowIconOnly() {
        return this.showIconOnly;
    }

    public void showBackgroundColor(boolean showIt) {
        this.showBackgroundColor = showIt;
        OrderMateThemeI.Helper.setButtonColour(this, this.information.getForegroundColor(), this.information.getBackgroundColor());
    }

    public void clearData() {
        this.information = null;
        this.setText("");
        this.setIcon(null);
        this.setBackground(null);
    }
}

