/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.button;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import ordermate.OrderMate;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.button.CustomButtonRenderer;

public class CustomToggleButton<T extends Displayable>
extends JToggleButton {
    private static final String NORMAL_COLOUR = "UntoggledColour";
    private static final int BUTTON_MIN_SIZE = 60;
    private T information;

    public CustomToggleButton() {
        this.init();
        this.setRolloverEnabled(false);
    }

    public CustomToggleButton(T info) {
        this();
        super.init(info);
    }

    private void init() {
        Dimension max = this.getMaximumSize();
        if (max.height < 60) {
            max.height = 60;
        }
        if (max.width < 60) {
            max.width = 60;
        }
        this.setMaximumSize(max);
        Dimension preferred = this.getPreferredSize();
        if (preferred.height < 60) {
            preferred.height = 60;
        }
        if (preferred.width < 60) {
            preferred.width = 60;
        }
        this.setPreferredSize(preferred);
        this.setMinimumSize(new Dimension(60, 60));
    }

    public T getData() {
        if (this.information instanceof CustomButtonRenderer) {
            return ((CustomButtonRenderer)this.information).getData();
        }
        return this.information;
    }

    public void setData(T info) {
        this.init(info);
    }

    @Override
    protected void fireItemStateChanged(ItemEvent event) {
        super.fireItemStateChanged(event);
        if (event.getStateChange() == 1) {
            if (this.getBackground() != null && this.getBackground() != this.getData().getBackgroundColor() && this.getBackground() != UIManager.getColor("ToggleButton.select")) {
                this.putClientProperty(NORMAL_COLOUR, this.getBackground());
            }
            this.setBackground(UIManager.getColor("ToggleButton.select"));
        } else if (event.getStateChange() == 2) {
            this.setBackground((Color)this.getClientProperty(NORMAL_COLOUR));
        }
    }

    private void init(T info) {
        this.information = info;
        if (info.getLabel() != null) {
            this.setText(info.getLabel());
        }
        Color fgColor = info.getForegroundColor();
        Color bgColor = info.getBackgroundColor();
        if (bgColor != null) {
            this.putClientProperty(NORMAL_COLOUR, bgColor);
        }
        OrderMateThemeI.Helper.setButtonColour(this, fgColor, bgColor);
        if (this.isSelected()) {
            this.setBackground(UIManager.getColor("ToggleButton.select"));
        }
        if (info.getIcon() != null) {
            String icon = info.getIcon();
            try {
                if (!icon.equalsIgnoreCase("")) {
                    this.setIcon(IconLoader.get(icon));
                    this.setIconTextGap(10);
                } else {
                    this.setIcon(null);
                }
            }
            catch (Exception e) {
                OrderMate.LOG.error(e + "\nExpected image not found : " + icon, (Throwable)e);
            }
        }
        Class<?> displayType = info.getClass();
        String name = displayType.getName();
        this.setName(name);
    }

    @Override
    public String toString() {
        return this.getText();
    }
}

