/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JLabel;
import ordermate.gui.button.CustomButton;

public class MultiLineCustomButton
extends CustomButton {
    private static final GridLayout ONE_LINE = new GridLayout(1, 1);
    private static final GridLayout TWO_LINES = new GridLayout(2, 1);
    private int textWidth;
    private String originalText = "";
    private boolean isPainting = false;
    private JLabel[] currentLabels;

    public MultiLineCustomButton() {
        this(15);
    }

    public MultiLineCustomButton(int charWidth) {
        this.textWidth = charWidth;
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
    }

    @Override
    public void setText(String text) {
        String newText = text;
        if (this.getShowIconOnly() && this.getIcon() != null) {
            this.setHorizontalAlignment(0);
            newText = "";
        } else {
            this.setHorizontalAlignment(2);
        }
        if (this.originalText != null && this.originalText.equals(newText)) {
            return;
        }
        this.originalText = newText;
        String[] theLines = this.breakText(newText);
        if (this.currentLabels == null || this.currentLabels.length != theLines.length) {
            this.createLabels(theLines.length);
        }
        for (int i = 0; i < theLines.length; ++i) {
            this.currentLabels[i].setText(theLines[i]);
        }
    }

    private void createLabels(int numLines) {
        this.removeAll();
        if (numLines == 1) {
            this.setLayout(ONE_LINE);
        } else if (numLines == 2) {
            this.setLayout(TWO_LINES);
        } else {
            this.setLayout(new GridLayout(numLines, 1));
        }
        this.currentLabels = new JLabel[numLines];
        for (int i = 0; i < numLines; ++i) {
            this.currentLabels[i] = new JLabel();
            this.currentLabels[i].setForeground(this.getForeground());
            this.currentLabels[i].setHorizontalAlignment(0);
            if (i == 0 && numLines > 1) {
                this.currentLabels[i].setVerticalAlignment(3);
            } else if (i == numLines - 1 && numLines > 1) {
                this.currentLabels[i].setVerticalAlignment(1);
            }
            this.add(this.currentLabels[i]);
        }
    }

    public void setTextWidth(int newTextWidth) {
        if (newTextWidth <= 0) {
            throw new IllegalArgumentException("text width must be greater than zero : " + newTextWidth);
        }
        this.textWidth = newTextWidth;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.isPainting = true;
        super.paintComponent(g);
        this.isPainting = false;
    }

    @Override
    public String getText() {
        if (this.isPainting) {
            return null;
        }
        return this.originalText;
    }

    @Override
    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        Component[] allComps = this.getComponents();
        for (int i = 0; i < allComps.length; ++i) {
            allComps[i].setForeground(foreground);
        }
    }

    @Override
    public void setHorizontalTextPosition(int alignment) {
        int iconAlign;
        if (alignment == 2) {
            iconAlign = 4;
        } else if (alignment == 4) {
            iconAlign = 2;
        } else {
            throw new IllegalArgumentException("The alignment value " + alignment + " is not valid for this implementation");
        }
        this.setHorizontalAlignment(iconAlign);
    }

    private String[] breakText(String theText) {
        String text = theText.trim();
        int theMidSpace = -1;
        if (theText.length() > this.textWidth) {
            int i;
            int left = (text.length() + 1) / 2;
            int right = (text.length() - 1) / 2;
            for (i = text.length() / 2; i > 0; --i) {
                if (text.charAt(left) == ' ') {
                    theMidSpace = left;
                    break;
                }
                if (right <= this.textWidth && text.charAt(right) == ' ') {
                    theMidSpace = right;
                    break;
                }
                --left;
                ++right;
            }
            if (theMidSpace == -1) {
                for (i = this.textWidth; i < text.length(); ++i) {
                    if (text.charAt(i) != ' ') continue;
                    theMidSpace = i;
                    break;
                }
            }
            if (theMidSpace != -1 && theMidSpace < text.length()) {
                String[] lines = new String[]{text.substring(0, theMidSpace).trim(), text.substring(theMidSpace).trim()};
                return lines;
            }
        }
        String[] line = new String[]{text};
        return line;
    }
}

