/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.delivery;

import au.com.ordermate.gui.GuiHandler;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.Lockable;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;

public class DeliveryGuiHelper {
    private GuiHandler gui;

    public DeliveryGuiHelper(GuiHandler ui) {
        this.gui = ui;
    }

    public boolean doReturn(Delivery delivery, User lockingUser) {
        if (!delivery.lock(lockingUser)) {
            if (this.attemptUnlock(delivery)) {
                return false;
            }
            if (!delivery.lock(lockingUser)) {
                return false;
            }
        }
        boolean result = false;
        boolean goAhead = this.gui.displayForcedChoiceDialog("Confirm Return?", "Confirm return of " + delivery.getDeliveryDetails() + "?", "Yes", "No");
        if (goAhead) {
            for (PhoneAccount currentAccount : delivery.getAccounts()) {
                currentAccount.setDelivered();
                if (currentAccount.getEta() != null) continue;
                OrderMate.LOG.warn("No Eta when delivered. Setting eta to now for account:" + currentAccount.getID());
                currentAccount.setEta(new Date());
            }
            if (delivery.getOpenAccounts().isEmpty()) {
                delivery.markAsReturned();
            }
            delivery.setTimeCompleted(new Date());
            delivery.save();
            result = true;
            OrderMate.LOG.info("Delivery returned:" + delivery.getDeliveryDetails());
        }
        delivery.unlock();
        return result;
    }

    protected boolean attemptUnlock(Lockable delivery) {
        return false;
    }

    public boolean obtainLock(Lockable lockable, String name, User lockingUser) {
        if (!lockable.lock(lockingUser)) {
            if (!this.attemptUnlock(lockable)) {
                return false;
            }
            if (!lockable.lock(lockingUser)) {
                return false;
            }
        }
        return true;
    }
}

