/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.delivery;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.delivery.DeliveryGuiHelper;
import ordermate.integration.drivertracking.DBDriverTrackingClientFactory;
import ordermate.internationalization.Internationalization;

public class DeliveryHandler {
    private GuiHandler gui;
    private boolean flagUnpaidOrderSkipped = false;
    private final DeliveryGuiHelper deliveryHelper;
    private static final String GENERIC_ERROR_TITLE = Internationalization.getLiteralFor("DTI_DELIVERY_GENERIC_ERROR_TITLE");
    private static final String GENERIC_ERROR_MSG = Internationalization.getLiteralFor("DTI_DELIVERY_GENERIC_ERROR_MSG");
    private static final String GENERIC_ERROR_TITLE_RETRY = Internationalization.getLiteralFor("DTI_DELIVERY_GENERIC_ERROR_TITLE_RETRY");
    private static final String UNPAID_ORDER_TITLE = Internationalization.getLiteralFor("DTI_DELIVERY_CANT_ASSIGN_UNPAID_TITLE");
    private static final String UNPAID_ORDER_MSG = Internationalization.getLiteralFor("DTI_DELIVERY_CANT_ASSIGN_UNPAID_MSG");
    private static final String YES = Internationalization.getLiteralFor("YES");
    private static final String NO = Internationalization.getLiteralFor("NO");

    public DeliveryHandler(DeliveryGuiHelper helper, GuiHandler yourGui) {
        this.deliveryHelper = helper;
        this.gui = yourGui;
    }

    public void handleDeliveryAssignment(List<PhoneAccount> accountsToAssign, User driver, User authorizingUser) {
        if (driver.getDriverTracking() != null) {
            this.handleIntegratedDelivery(accountsToAssign, driver, authorizingUser);
        } else {
            this.handleInternally(accountsToAssign, driver, authorizingUser);
        }
    }

    private boolean handleIntegratedDelivery(List<PhoneAccount> accounts, User driver, User authUser) {
        AssignDeliveryToIntegratedDriverTask task = new AssignDeliveryToIntegratedDriverTask(accounts, driver, authUser);
        this.gui.doProgressTask(task);
        if (!task.getResult()) {
            boolean retry = this.gui.displayForcedChoiceDialog(GENERIC_ERROR_TITLE, GENERIC_ERROR_MSG + driver.getName() + GENERIC_ERROR_TITLE_RETRY, YES, NO);
            if (retry) {
                this.handleIntegratedDelivery(accounts, driver, authUser);
            }
        } else if (this.flagUnpaidOrderSkipped) {
            this.gui.displayErrorDialog(UNPAID_ORDER_MSG, UNPAID_ORDER_TITLE, "");
        }
        return task.getResult();
    }

    private boolean handleInternally(List<PhoneAccount> accounts, User currentDriver, User authorizingUser) {
        Delivery delivery = Delivery.getCurrentDelivery(currentDriver);
        if (delivery == null) {
            delivery = Delivery.createDelivery(currentDriver, authorizingUser, Collections.EMPTY_LIST);
        }
        boolean needsLocking = delivery.isPersistent();
        boolean locked = false;
        if (needsLocking && !(locked = delivery.lock(authorizingUser))) {
            locked = this.deliveryHelper.attemptUnlock(delivery);
        }
        if (locked || !needsLocking) {
            for (PhoneAccount account : accounts) {
                if (!delivery.getAccounts().contains(account)) {
                    if (account.getDelivery() != null) {
                        if (!authorizingUser.hasPermission(AllPermissions.ASSIGN_DELIVERY_TO_OTHERS)) {
                            this.gui.displayOkDialog("Cannot reassign order", "This account already has a driver, you do not have permission to reassign");
                            continue;
                        }
                        if (!this.gui.displayForcedChoiceDialog("Change driver for account?", "<HTML>The account " + account.getLabel() + " currently belongs to the driver : " + account.getDelivery().getDriver() + "<P>Do you want to change it to " + delivery.getDriver() + "?", "Yes", "No")) continue;
                        Delivery oldDelivery = account.getDelivery();
                        oldDelivery.removeAccount(account);
                        TerminalEventLog.logAssignOrderToDelivery(new EventContext(authorizingUser), account, oldDelivery, false);
                    }
                    delivery.addAccount(account);
                    TerminalEventLog.logAssignOrderToDelivery(new EventContext(authorizingUser), account, delivery, true);
                    continue;
                }
                this.gui.displayOkDialog("Delivery already has account", "This delivery already contains this account");
            }
            delivery.save();
            delivery.unlock();
        }
        return true;
    }

    private class AssignDeliveryToIntegratedDriverTask
    extends AbstractGuiTask {
        private final List<PhoneAccount> accountsToAssign;
        private final User authorizer;
        private final User driver;
        private boolean result = true;

        AssignDeliveryToIntegratedDriverTask(List<PhoneAccount> theAccounts, User theDriver, User authorizingUser) {
            this.driver = theDriver;
            this.authorizer = authorizingUser;
            this.accountsToAssign = theAccounts;
        }

        boolean getResult() {
            return this.result;
        }

        @Override
        protected void doGuiTask() throws Exception {
            for (PhoneAccount account : this.accountsToAssign) {
                this.result = this.result && this.doAssign(account);
                this.emitProgress();
            }
        }

        private boolean doAssign(PhoneAccount account) {
            if (account == null) {
                OrderMate.LOG.error("Cannot assign a null account");
                return false;
            }
            if (!account.isLocked(this.authorizer) && !account.lock(this.authorizer)) {
                OrderMate.LOG.warn("Cannot assign - cannot lock account");
                return false;
            }
            boolean successful = DBDriverTrackingClientFactory.Instance.getClient().assignDelivery(account, this.driver);
            if (successful) {
                Delivery delivery = Delivery.createDelivery(this.driver, this.authorizer, Collections.singletonList(account));
                delivery.setStoreId(account.getStoreId());
                delivery.save();
                delivery.unlock();
                TerminalEventLog.logAssignOrderToDelivery(new EventContext(this.authorizer), account, delivery, true);
            } else {
                OrderMate.LOG.warn("Failed to assign account #" + account.getID() + " to an integrated delivery driver " + this.driver.getName() + "!");
            }
            if (account.isLocked()) {
                account.unlock();
            }
            return successful;
        }

        @Override
        public String getName() {
            return "Assigning account(s) to " + this.driver.getName() + "...";
        }

        @Override
        protected int getTotalSubTasks() {
            return this.accountsToAssign.size();
        }
    }
}

