/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.dialogs;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import ordermate.OrderMate;
import ordermate.cryptomatic.Cryptomatic;
import ordermate.database.misc.ApplicationType;
import ordermate.database.misc.SystemPassword;
import ordermate.database.users.User;
import ordermate.gui.AutoCompletion;
import ordermate.gui.BorderUtils;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.dialogs.UserRenderer;
import ordermate.internationalization.Internationalization;

public class LoginDialog
extends JDialog
implements ActionListener {
    private static final int SECRET_LOGIN_MODIFIER = 11;
    private JButton loginButton;
    private JButton exitButton;
    private JComboBox userCombo;
    private JTextField pwdText;
    private JCheckBox eulaCheckBox;
    private JLabel errorMessageLabel;
    private static User loggedinUser;

    private LoginDialog(Frame owner, List<User> users, String message, String buttonText) {
        super(owner, "Log In", true);
        this.userCombo = new JComboBox<Object>(users.toArray());
        this.userCombo.addActionListener(this);
        this.userCombo.setPreferredSize(new Dimension(150, 20));
        this.userCombo.setRenderer(new UserRenderer());
        this.userCombo.setName("userSelectCombo");
        AutoCompletion.enable(this.userCombo);
        this.pwdText = new JPasswordField();
        this.pwdText.setPreferredSize(new Dimension(150, 20));
        this.pwdText.addActionListener(this);
        this.pwdText.setName("inputCredentals");
        this.loginButton = new JButton("Log In", IconLoader.get("/ordermate/images/logout_icon16.png"));
        this.loginButton.setName("loginButton");
        this.loginButton.addActionListener(this);
        this.exitButton = new JButton(buttonText, IconLoader.get("/ordermate/images/exit_icon16.png"));
        this.exitButton.addActionListener(this);
        JLabel messageLabel = new JLabel(message);
        messageLabel.setPreferredSize(new Dimension(300, 26));
        messageLabel.setHorizontalAlignment(0);
        this.errorMessageLabel = new JLabel();
        this.errorMessageLabel.setHorizontalAlignment(0);
        this.errorMessageLabel.setPreferredSize(new Dimension(300, 26));
        this.errorMessageLabel.setForeground(Color.red);
        FieldPanelBuilder fieldPanel = new FieldPanelBuilder();
        fieldPanel.addRow("User name:", (Component)this.userCombo);
        fieldPanel.addRow("Password:", (Component)this.pwdText);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.loginButton);
        buttonPanel.add(this.exitButton);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)buttonPanel, "East");
        JPanel comboPanel = fieldPanel.getPanel();
        comboPanel.setAlignmentX(0.5f);
        comboPanel.setAlignmentY(0.5f);
        comboPanel.setBorder(BorderFactory.createEmptyBorder(10, 40, 5, 40));
        JPanel centerComboPanel = new JPanel(new BorderLayout());
        centerComboPanel.add((Component)messageLabel, "North");
        centerComboPanel.add((Component)comboPanel, "Center");
        centerComboPanel.add((Component)this.errorMessageLabel, "South");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)centerComboPanel, "North");
        panel.add((Component)this.makeEulaPanel(), "Center");
        panel.add((Component)southPanel, "South");
        BorderUtils.addEmptyBorder(panel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(panel);
        this.setResizable(false);
        this.setSize(320, 240);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(owner);
    }

    private JPanel makeEulaPanel() {
        this.eulaCheckBox = new JCheckBox();
        this.eulaCheckBox.setName("eulaCheckButton");
        this.eulaCheckBox.setSelected(true);
        this.eulaCheckBox.setAlignmentY(0.5f);
        this.eulaCheckBox.setAlignmentX(0.0f);
        this.eulaCheckBox.addActionListener(this);
        String acceptTerms = Internationalization.getLiteralFor("ACCEPT_TERMS");
        JLabel eulaLabel = new JLabel(this.getFirstEulaLabelPart(acceptTerms));
        JLabel eulaLabel2 = new JLabel(this.getSecondEulaLabelPart(acceptTerms));
        JLabel eulaDisplayLabel = new JLabel(new HtmlBuilder().appendColor(Internationalization.getLiteralFor("ORDERMATE_EULA"), "blue").toString());
        eulaDisplayLabel.setCursor(Cursor.getPredefinedCursor(12));
        eulaDisplayLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LoginDialog.this.displayEulaInBrowser();
            }
        });
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 0));
        leftPanel.add(this.eulaCheckBox);
        leftPanel.add(Box.createVerticalStrut(20));
        JPanel centerPanel = new JPanel(new FlowLayout(0, 1, 0));
        centerPanel.add(eulaLabel);
        centerPanel.add(eulaLabel2);
        centerPanel.add(eulaDisplayLabel);
        JPanel eulaHolder = new JPanel(new BorderLayout(1, 0));
        eulaHolder.add((Component)leftPanel, "West");
        eulaHolder.add((Component)centerPanel, "Center");
        eulaHolder.setBorder(BorderFactory.createEmptyBorder(1, 65, 5, 1));
        return eulaHolder;
    }

    private String getFirstEulaLabelPart(String acceptTerms) {
        try {
            return acceptTerms.substring(0, acceptTerms.indexOf(" ", 37));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot find EULA Terms first part.");
            return acceptTerms;
        }
    }

    private String getSecondEulaLabelPart(String acceptTerms) {
        try {
            return acceptTerms.substring(acceptTerms.lastIndexOf(" ", 38) + 1);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot find EULA Terms first part.");
            return acceptTerms;
        }
    }

    public static User getLogin(Frame owner, List<User> users, String message, String buttonText) {
        LoginDialog loginDialog = new LoginDialog(owner, users, message, buttonText);
        loggedinUser = null;
        loginDialog.setVisible(true);
        return loggedinUser;
    }

    void gotLoginAttempt(User toLogin, String givenPassword, Boolean isSecretLoginEnabled) {
        loggedinUser = null;
        if (isSecretLoginEnabled.booleanValue() && (SystemPassword.validate(givenPassword, ApplicationType.OfficeMate) || Config.isDebuging() || givenPassword.equals(new Cryptomatic().makePass()))) {
            loggedinUser = User.getSystemAdministrator();
            this.setVisible(false);
        } else {
            String actualPassword;
            String string = actualPassword = toLogin != null ? toLogin.getPassword() : null;
            if (toLogin == null || actualPassword == null || actualPassword.length() == 0 || !givenPassword.equals(actualPassword)) {
                this.errorMessageLabel.setText("Incorrect user name or password. Login failed");
                loggedinUser = null;
            } else {
                loggedinUser = toLogin;
                this.setVisible(false);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.pwdText.setText("");
            this.errorMessageLabel.setText("");
        }
        super.setVisible(visible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.loginButton || source == this.pwdText) {
            User user = (User)this.userCombo.getSelectedItem();
            String givenPassword = this.pwdText.getText();
            boolean secretEnabled = (e.getModifiers() & 0xB) != 0;
            this.gotLoginAttempt(user, givenPassword, secretEnabled);
        } else if (source == this.exitButton) {
            this.setVisible(false);
        } else if (source == this.eulaCheckBox) {
            this.eulaEnableLoginToggle();
        }
    }

    private void eulaEnableLoginToggle() {
        boolean enabled = this.eulaCheckBox.isSelected();
        this.userCombo.setEnabled(enabled);
        this.pwdText.setEnabled(enabled);
        this.loginButton.setEnabled(enabled);
    }

    private void displayEulaInBrowser() {
        String url = "http://www.ordermate.com.au/eula";
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(URI.create(url));
            } else {
                JOptionPane.showMessageDialog(this, Internationalization.getLiteralFor("COULD_NOT_OPEN") + " " + url, Internationalization.getLiteralFor("UNABLE_TO_OPEN_URL"), 2);
            }
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Internationalization.getLiteralFor("COULD_NOT_OPEN") + " " + url, Internationalization.getLiteralFor("UNABLE_TO_OPEN_URL"), 2);
            OrderMate.LOG.warn(Internationalization.getLiteralFor("COULD_NOT_OPEN"), (Throwable)ex);
            return;
        }
    }
}

