/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.dialogs;

import au.com.ordermate.guicore.task.ProgressBarConnector;
import au.com.ordermate.guicore.task.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;

public class ProgressDialog
extends JDialog {
    private volatile boolean success;
    private Runnable theTask;
    private final String taskName;
    JProgressBar progressBar = new JProgressBar();

    public ProgressDialog(Frame owner, boolean modal, Task task) {
        this(owner, modal, task.getName(), task);
        this.progressBar.setIndeterminate(false);
        ProgressBarConnector.connect(this.progressBar, task);
    }

    public ProgressDialog(Frame owner, boolean modal, String name, Runnable task) {
        super(owner, name, modal);
        this.theTask = task;
        this.taskName = name;
        this.progressBar.setIndeterminate(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.progressBar, "Center");
        contentPane.setMinimumSize(new Dimension(300, 30));
        contentPane.setPreferredSize(new Dimension(300, 30));
        contentPane.setMaximumSize(new Dimension(300, 30));
    }

    public boolean start() {
        this.success = false;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        Thread progressThread = new Thread(new ProgressRunner());
        progressThread.setName("Progress Thread");
        progressThread.start();
        this.setVisible(true);
        return this.success;
    }

    private class ProgressRunner
    implements Runnable {
        private ProgressRunner() {
        }

        @Override
        public void run() {
            try {
                ProgressDialog.this.theTask.run();
                ProgressDialog.this.success = true;
            }
            catch (Exception e) {
                String error = "An error occurred performing " + ProgressDialog.this.taskName;
                OrderMate.LOG.error(error, (Throwable)e);
                ProgressDialog.this.success = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.dispose();
                }
            });
        }
    }
}

