/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import ordermate.database.users.User;

public class UserRenderer
extends DefaultListCellRenderer {
    private final Color BACK_1 = Color.WHITE;
    private final Color BACK_2 = new Color(255, 245, 245);
    private final Color HIGHLIGHT = new Color(250, 230, 230);
    private final Color LOCAL = Color.black;
    private final Color HO = Color.gray;

    public UserRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(this.HIGHLIGHT);
        } else if (index % 2 == 0) {
            this.setBackground(this.BACK_1);
        } else {
            this.setBackground(this.BACK_2);
        }
        User user = (User)value;
        if (user.isHeadOffice()) {
            this.setText(user.getName() + " (Head Office)");
            this.setForeground(this.HO);
        } else {
            this.setText(user.getName());
            this.setForeground(this.LOCAL);
        }
        return this;
    }
}

