/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.duplicate;

import au.com.ordermate.duplicate.Duplicate;
import au.com.ordermate.duplicate.DuplicateDetectionStrategy;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Map;

public abstract class WeightedPropertyDetectionStrategy<T extends PropertiedObject>
implements DuplicateDetectionStrategy<T> {
    private static final double DEFAULT_CUTOFF = 0.6;
    private double cutoff = 0.6;
    private Map<PropertiedObject.Property<?>, Integer> weightMap = this.createPropertyWeightMap();

    public void setCutoff(double value) {
        this.cutoff = value;
    }

    @Override
    public Duplicate<T> compare(T first, T second) {
        long total = 0L;
        for (Integer nextInt : this.weightMap.values()) {
            if (nextInt == null) {
                throw new IllegalArgumentException("Cannot weight an item with a null weight.");
            }
            total += (long)nextInt.intValue();
        }
        double tally = 0.0;
        for (PropertiedObject.Property<?> prop : this.weightMap.keySet()) {
            tally += (double)this.matchValues(first.getPropertyValue(prop), second.getPropertyValue(prop), this.weightMap.get(prop));
        }
        double score = tally / (double)total;
        if (score >= this.cutoff) {
            return new Duplicate<T>(first, second);
        }
        return null;
    }

    private int matchValues(Object firstValue, Object secondValue, Integer weight) {
        if (firstValue == null || secondValue == null) {
            return weight;
        }
        String first = String.valueOf(firstValue).toLowerCase();
        String second = String.valueOf(secondValue).toLowerCase();
        if (first.isEmpty() || second.isEmpty()) {
            return weight;
        }
        if (first.equals(second)) {
            return weight;
        }
        if (first.startsWith(second) || first.endsWith(second)) {
            return 0;
        }
        if (second.startsWith(first) || second.endsWith(first)) {
            return 0;
        }
        return -weight.intValue();
    }

    protected abstract Map<PropertiedObject.Property<?>, Integer> createPropertyWeightMap();
}

