/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.duplicate.customer;

import au.com.ordermate.duplicate.Duplicate;
import au.com.ordermate.duplicate.DuplicateDetectionStrategy;
import au.com.ordermate.persistence.PropertiedObject;
import ordermate.database.sales.Customer;
import ordermate.gui.duplicate.customer.CustomerDuplicateDetectionStrategyType;

public class CustomerCardDuplicateDetectionStrategy
implements DuplicateDetectionStrategy<Customer> {
    @Override
    public Duplicate<Customer> compare(Customer first, Customer second) {
        if (first != null && second != null && first.getCardID() != null && !first.getCardID().isEmpty() && first.getCardID().equalsIgnoreCase(second.getCardID())) {
            return new Duplicate<Customer>(first, second);
        }
        return null;
    }

    @Override
    public PropertiedObject.Property getSearchOrderByProperty() {
        return Customer.Properties.CARD_ID;
    }

    @Override
    public CustomerDuplicateDetectionStrategyType getType() {
        return CustomerDuplicateDetectionStrategyType.CardNo;
    }
}

