/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.duplicate.customer;

import au.com.ordermate.duplicate.Duplicate;
import au.com.ordermate.duplicate.DuplicateDetectionStrategy;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import ordermate.database.sales.Customer;
import ordermate.gui.duplicate.customer.CustomerDuplicateDetectionStrategyType;

public class CustomerDuplicateDetectionStrategy
implements DuplicateDetectionStrategy<Customer> {
    @Override
    public Duplicate<Customer> compare(Customer first, Customer second) {
        boolean primaryMatch = true;
        String firstString = this.nullIfEmpty(first.getFirstName(), 1);
        String secondString = this.nullIfEmpty(second.getFirstName(), 1);
        if (firstString != null && secondString != null) {
            boolean bl = primaryMatch = StringUtils.startsWithIgnoreCase(firstString, secondString) || StringUtils.startsWithIgnoreCase(secondString, firstString);
        }
        if (primaryMatch) {
            firstString = this.nullIfEmpty(first.getLastName(), 1);
            secondString = this.nullIfEmpty(second.getLastName(), 1);
            if (firstString != null && secondString != null) {
                boolean bl = primaryMatch = StringUtils.startsWithIgnoreCase(firstString, secondString) || StringUtils.startsWithIgnoreCase(secondString, firstString);
            }
        }
        if (!primaryMatch) {
            return null;
        }
        boolean secondaryMatch = false;
        firstString = this.nullIfEmpty(first.getPrimaryPhoneNumber(), 6);
        secondString = this.nullIfEmpty(second.getPrimaryPhoneNumber(), 6);
        String firstPhone = this.nullIfEmpty(first.getSecondaryPhoneNumber(), 6);
        String secondPhone = this.nullIfEmpty(second.getSecondaryPhoneNumber(), 6);
        if (!(firstString == null && firstPhone == null || secondString == null && secondPhone == null)) {
            if (firstString != null) {
                boolean bl = secondaryMatch = secondString != null && (firstString.startsWith(secondString) || secondString.startsWith(firstString)) || secondPhone != null && (firstString.startsWith(secondPhone) || secondPhone.startsWith(firstString));
            }
            if (!secondaryMatch && firstPhone != null) {
                boolean bl = secondaryMatch = secondString != null && (firstPhone.startsWith(secondString) || secondString.startsWith(firstPhone)) || secondPhone != null && (firstPhone.startsWith(secondPhone) || secondPhone.startsWith(firstPhone));
            }
        }
        if (!secondaryMatch && !this.isEmpty(firstString = first.getEmail(), secondString = second.getEmail())) {
            secondaryMatch = firstString.equalsIgnoreCase(secondString);
        }
        if (secondaryMatch) {
            return new Duplicate<Customer>(first, second);
        }
        return null;
    }

    private String nullIfEmpty(String string, int length) {
        return string == null || string.length() < length || string.trim().length() < length ? null : string;
    }

    private boolean isEmpty(String first, String second) {
        return first == null || second == null || first.isEmpty() || second.isEmpty();
    }

    @Override
    public PropertiedObject.Property getSearchOrderByProperty() {
        return Customer.Properties.FIRST_NAME;
    }

    @Override
    public CustomerDuplicateDetectionStrategyType getType() {
        return CustomerDuplicateDetectionStrategyType.Default;
    }
}

