/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.duplicate.customer;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Comparator;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;

public class CustomerHistorySorter
implements Comparator<Customer> {
    ObjectQuery baseQuery;

    public CustomerHistorySorter() {
        this.baseQuery = Query.select(Account.class).orderBy(Account.Properties.CREATION_DATE_TIME).equals(Account.Properties.CUSTOMER, (Object)" ? ", true).limit(1);
    }

    @Override
    public int compare(Customer o1, Customer o2) {
        Account account1 = PersistenceManager.getObject(Account.class, this.baseQuery.copy().toString(), new Object[]{o1});
        Account account2 = PersistenceManager.getObject(Account.class, this.baseQuery.copy().toString(), new Object[]{o2});
        if (account1 != null) {
            if (account2 == null || account1.getCreationDateTime().before(account2.getCreationDateTime())) {
                return -1;
            }
            return 1;
        }
        if (account2 != null) {
            return 1;
        }
        return 0;
    }
}

