/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.duplicate.customer;

import au.com.ordermate.persistence.PropertiedObject;
import java.util.Comparator;
import ordermate.database.sales.Customer;

public class CustomerMostDetailsSorter
implements Comparator<Customer> {
    private final PropertiedObject.Property[] PROPS_TO_CHECK;

    public CustomerMostDetailsSorter() {
        this.PROPS_TO_CHECK = new PropertiedObject.Property[]{Customer.Properties.FIRST_NAME, Customer.Properties.LAST_NAME, Customer.Properties.PRIMARY_PHONE_NUMBER, Customer.Properties.SECONDARY_PHONE_NUMBER, Customer.Properties.HOUSE_NUMBER, Customer.Properties.ROOM_APT_NUMBER, Customer.Properties.STREET_NAME, Customer.Properties.STREET_TYPE, Customer.Properties.TITLE, Customer.Properties.E_MAIL, Customer.Properties.DOB};
    }

    @Override
    public int compare(Customer o1, Customer o2) {
        return this.getCustomerDetailWeight(o2) - this.getCustomerDetailWeight(o1);
    }

    private int getCustomerDetailWeight(Customer customer) {
        int cusWeight = 0;
        if (customer != null) {
            for (PropertiedObject.Property prop : this.PROPS_TO_CHECK) {
                if (prop.getType() == String.class) {
                    String value = (String)customer.getPropertyValue(prop);
                    if (value == null || value.isEmpty()) continue;
                    ++cusWeight;
                    continue;
                }
                if (customer.getPropertyValue(prop) == null) continue;
                ++cusWeight;
            }
        }
        return cusWeight;
    }
}

