/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.keyboard;

import info.clearthought.layout.TableLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import ordermate.gui.keyboard.DefaultKeyboardDimensions;
import ordermate.gui.keyboard.KeyboardDimensions;
import ordermate.gui.keyboard.KeyboardPanel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class Keyboard
extends JPanel
implements AncestorListener,
HierarchyListener {
    private static final int MAX_CHARS = 30;
    private static final char spaceChar = ' ';
    private final boolean enableAdvance;
    private final boolean autCaps;
    private final boolean maxChars;
    private boolean isShortNames = false;
    private String initial;
    private final KeyboardDimensions dim;
    private boolean numbersOnly;
    private boolean keysEnabled = true;
    private String enteredString = "";
    public final Signal updated = Signals.createSignal(String.class, "keyboardValue");
    private static final Dimension DEFAULT_PREFERRED_SIZE = new Dimension(780, 260);

    public Keyboard() {
        this(false, true, false);
    }

    public Keyboard(boolean enableAdvancedButtons) {
        this(enableAdvancedButtons, true, false);
    }

    public Keyboard(boolean enableAdvancedButtons, boolean automaticallyCapitalize) {
        this(enableAdvancedButtons, automaticallyCapitalize, false);
    }

    public Keyboard(boolean enableAdvancedButtons, boolean automaticallyCapitalize, boolean toUseMaxChars) {
        this(enableAdvancedButtons, automaticallyCapitalize, toUseMaxChars, "", null);
    }

    public Keyboard(boolean enableAdvancedButtons, boolean automaticallyCapitalize, boolean toUseMaxChars, String initialString, KeyboardDimensions keyboardDimensions) {
        super((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}}));
        this.enableAdvance = enableAdvancedButtons;
        this.autCaps = automaticallyCapitalize;
        this.maxChars = toUseMaxChars;
        this.initial = initialString;
        this.dim = keyboardDimensions == null ? DefaultKeyboardDimensions.getInstance() : keyboardDimensions;
        this.addHierarchyListener(this);
        this.setPreferredSize(new Dimension(DEFAULT_PREFERRED_SIZE));
    }

    private void updated() {
        this.updated.emit(this.enteredString);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (KeyboardPanel.getInstance().getCurrentKeyboard() != this) {
            KeyboardPanel panel = KeyboardPanel.getInstance();
            panel.configure(this);
            this.enableKeys(this.keysEnabled);
            this.enableNumbersOnly(this.numbersOnly);
            this.setShortNames(this.isShortNames);
            if (this.isAutoCaps() && this.enteredString.equals("")) {
                this.setCaps(true);
            }
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        if (KeyboardPanel.getInstance().getCurrentKeyboard() == this) {
            KeyboardPanel.getInstance().configure(null);
        }
    }

    public KeyboardDimensions getDimensions() {
        return this.dim;
    }

    public boolean isAutoCaps() {
        return this.autCaps;
    }

    public boolean isUseMaxChars() {
        return this.maxChars;
    }

    public String getInitialString() {
        return this.initial;
    }

    public boolean isAdvancedButtonsEnabled() {
        return this.enableAdvance;
    }

    public void clear() {
        this.enteredString = "";
        if (this.isAutoCaps()) {
            this.setCaps(true);
        }
        this.updated();
    }

    public void enableKeys(boolean value) {
        KeyboardPanel.getInstance().enableKeys(value);
    }

    public void setValue(String newValue) {
        this.enteredString = newValue != null ? newValue : "";
        this.initial = this.enteredString;
    }

    public String getValue() {
        return this.enteredString;
    }

    public void setCaps(boolean toUpper) {
        KeyboardPanel.getInstance().setCaps(toUpper);
    }

    public void enableNumbersOnly(boolean value) {
        this.numbersOnly = value;
        KeyboardPanel.getInstance().enableNumbersOnly(value);
    }

    public void setShift(boolean value) {
        KeyboardPanel.getInstance().setShift(value);
    }

    public void setShortNames(boolean value) {
        this.isShortNames = value;
        KeyboardPanel.getInstance().setShortNames(value);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (e.getChanged() == this && this.getParent() != null) {
            boolean found = false;
            AncestorListener[] listeners = ((JComponent)this.getParent()).getAncestorListeners();
            if (listeners != null) {
                for (AncestorListener listener : listeners) {
                    if (listener != this) continue;
                    found = true;
                }
            }
            if (!found) {
                ((JComponent)this.getParent()).addAncestorListener(this);
            }
        }
    }

    void gotString(String stringToEnter) {
        if (this.charsOkay(stringToEnter)) {
            this.enteredString = this.enteredString + stringToEnter;
            if (stringToEnter.equals(" ")) {
                if (this.isAutoCaps()) {
                    this.setShift(true);
                    this.setCaps(true);
                }
            } else if (KeyboardPanel.getInstance().isShiftSelected()) {
                if (KeyboardPanel.getInstance().isCapsSelected()) {
                    this.setCaps(true);
                } else {
                    this.setCaps(false);
                }
                this.setShift(false);
            } else if (!KeyboardPanel.getInstance().isCapsSelected()) {
                this.setCaps(false);
            }
            this.updated();
        }
    }

    void gotDelete() {
        if (this.enteredString.length() > 0) {
            if (this.enteredString.length() > 1 && this.isAutoCaps()) {
                if (this.enteredString.charAt(this.enteredString.length() - 2) == ' ') {
                    KeyboardPanel.getInstance().setShift(true);
                    this.setCaps(true);
                } else {
                    KeyboardPanel.getInstance().setShift(false);
                    this.setCaps(false);
                }
            }
            this.enteredString = this.enteredString.substring(0, this.enteredString.length() - 1);
        }
        if (this.enteredString.length() == 0 && !this.numbersOnly) {
            KeyboardPanel.getInstance().setShift(true);
            KeyboardPanel.getInstance().setCapsLockButton(false);
            this.setCaps(true);
        }
        this.updated();
    }

    boolean charsOkay(String charsToAdd) {
        boolean canAdd = this.keysEnabled;
        if (canAdd && this.numbersOnly) {
            char[] chars = charsToAdd.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) continue;
                canAdd = false;
                i = chars.length;
            }
        }
        if (canAdd && this.isUseMaxChars() && this.enteredString.length() + charsToAdd.length() >= 30) {
            canAdd = false;
        }
        return canAdd;
    }
}

