/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.keyboard;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.AncestorEvent;
import ordermate.gui.DefaultLostKeyListener;
import ordermate.gui.InputAdapterFactory;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.keyboard.DefaultKeyboardDimensions;
import ordermate.gui.keyboard.Keyboard;
import ordermate.gui.keyboard.KeyboardDimensions;

final class KeyboardPanel
implements ActionListener {
    private final String[] number = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    private final String[] letter = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String TILDE = "~";
    private static final String DASH = "-";
    private static final String UNDERSCORE = "_";
    private static final String COMMA = ",";
    private static final String FULLSTOP = ".";
    private static final String SEMICOLON = ";";
    private static final String FORWARDSLASH = "/";
    private static final String BACKSLASH = "\\";
    private static final String BACKSPACE = "Backspace";
    private static final String SPACE = "Space";
    private static final String TAB = "Tab";
    private static final String SHIFT = "Shift";
    private static final String ENTER = "Enter";
    private static final String CAPSLOCK = "Caps Lock";
    private static final String CONTROL = "Ctrl";
    private static final String CLEAR = "Clr";
    private static final String ALT = "Alt";
    private static final String AT = "@";
    private static final String CAPSLOCK_SHORT = "Caps";
    private static final String BACKSPACE_SHORT = "<<";
    private final JButton oneButton = new JButton(this.number[0]);
    private final JButton twoButton = new JButton(this.number[1]);
    private final JButton threeButton = new JButton(this.number[2]);
    private final JButton fourButton = new JButton(this.number[3]);
    private final JButton fiveButton = new JButton(this.number[4]);
    private final JButton sixButton = new JButton(this.number[5]);
    private final JButton sevenButton = new JButton(this.number[6]);
    private final JButton eightButton = new JButton(this.number[7]);
    private final JButton nineButton = new JButton(this.number[8]);
    private final JButton zeroButton = new JButton(this.number[9]);
    private final JButton aButton = new JButton(this.letter[0]);
    private final JButton bButton = new JButton(this.letter[1]);
    private final JButton cButton = new JButton(this.letter[2]);
    private final JButton dButton = new JButton(this.letter[3]);
    private final JButton eButton = new JButton(this.letter[4]);
    private final JButton fButton = new JButton(this.letter[5]);
    private final JButton gButton = new JButton(this.letter[6]);
    private final JButton hButton = new JButton(this.letter[7]);
    private final JButton iButton = new JButton(this.letter[8]);
    private final JButton jButton = new JButton(this.letter[9]);
    private final JButton kButton = new JButton(this.letter[10]);
    private final JButton lButton = new JButton(this.letter[11]);
    private final JButton mButton = new JButton(this.letter[12]);
    private final JButton nButton = new JButton(this.letter[13]);
    private final JButton oButton = new JButton(this.letter[14]);
    private final JButton pButton = new JButton(this.letter[15]);
    private final JButton qButton = new JButton(this.letter[16]);
    private final JButton rButton = new JButton(this.letter[17]);
    private final JButton sButton = new JButton(this.letter[18]);
    private final JButton tButton = new JButton(this.letter[19]);
    private final JButton uButton = new JButton(this.letter[20]);
    private final JButton vButton = new JButton(this.letter[21]);
    private final JButton wButton = new JButton(this.letter[22]);
    private final JButton xButton = new JButton(this.letter[23]);
    private final JButton yButton = new JButton(this.letter[24]);
    private final JButton zButton = new JButton(this.letter[25]);
    private final JButton dashButton = new JButton("-");
    private final JButton underScoreButton = new JButton("_");
    private final JButton commaButton = new JButton(",");
    private final JButton semicolonButton = new JButton(";");
    private final JButton fullStopButton = new JButton(".");
    private final JButton forwardSlashButton = new JButton("/");
    private final JButton tildeButton = new JButton("~");
    private final JButton backspaceButton = new JButton("Backspace");
    private final JButton tabButton = new JButton("Tab");
    private final JButton backslashButton = new JButton("\\");
    private final JToggleButton capsLockButton = new JToggleButton("Caps Lock");
    private final JButton enterButton = new JButton("Enter");
    private final JToggleButton shiftButton = new JToggleButton("Shift");
    private final JToggleButton shiftButton2 = new JToggleButton("Shift");
    private final JButton ctrlButton = new JButton("Ctrl");
    private final JButton clearButton = new JButton("Clr");
    private final JButton altButton = new JButton("Alt");
    private final JButton spaceButton = new JButton("Space");
    private final JButton atButton = new JButton("@");
    private final JButton[] functionButtonArray = new JButton[]{this.dashButton, this.underScoreButton, this.commaButton, this.fullStopButton, this.forwardSlashButton, this.tildeButton, this.backspaceButton, this.tabButton, this.backslashButton, this.enterButton, this.ctrlButton, this.clearButton, this.altButton, this.spaceButton, this.atButton, this.semicolonButton};
    private final JButton[] charButtonArray = new JButton[]{this.aButton, this.bButton, this.cButton, this.dButton, this.eButton, this.fButton, this.gButton, this.hButton, this.iButton, this.jButton, this.kButton, this.lButton, this.mButton, this.nButton, this.oButton, this.pButton, this.qButton, this.rButton, this.sButton, this.tButton, this.uButton, this.vButton, this.wButton, this.xButton, this.yButton, this.zButton};
    private final JButton[] numbButtonArray = new JButton[]{this.oneButton, this.twoButton, this.threeButton, this.fourButton, this.fiveButton, this.sixButton, this.sevenButton, this.eightButton, this.nineButton, this.zeroButton};
    private final JToggleButton[] toggleButtonArray = new JToggleButton[]{this.capsLockButton, this.shiftButton, this.shiftButton2};
    private final DefaultLostKeyListener lostKeySlot = new DefaultLostKeyListener(InputAdapterFactory.getAdapter());
    private static final KeyboardPanel instance = new KeyboardPanel();
    private Keyboard currentKeyboard;
    private KeyboardDimensions currentDimensions;
    private JPanel keyboardPanel;
    private JPanel[] rows;

    private KeyboardPanel() {
        this.lostKeySlot.gotDelete.connect(this, "gotDelete");
        this.lostKeySlot.gotClear.connect(this, "gotClear");
        this.lostKeySlot.gotCharacter.connect(this, "gotString");
        double p = -1.0;
        this.keyboardPanel = new JPanel((LayoutManager)new TableLayout((double[][])new double[][]{{p}, {p, p, p, p, p}}));
        this.lostKeySlot.setActive(false);
        this.initButtons();
    }

    private void initButtons() {
        int count;
        for (count = 0; count < this.functionButtonArray.length; ++count) {
            this.functionButtonArray[count].addActionListener(this);
            OrderMateThemeI.Helper.setupKeypadButton(this.functionButtonArray[count]);
            this.functionButtonArray[count].setBorder(null);
        }
        for (count = 0; count < this.numbButtonArray.length; ++count) {
            this.numbButtonArray[count].addActionListener(this);
            OrderMateThemeI.Helper.setupKeypadButton(this.numbButtonArray[count]);
            this.numbButtonArray[count].setBorder(null);
        }
        for (count = 0; count < this.toggleButtonArray.length; ++count) {
            this.toggleButtonArray[count].addActionListener(this);
            OrderMateThemeI.Helper.setupKeypadButton(this.toggleButtonArray[count]);
            this.toggleButtonArray[count].setBorder(null);
        }
        for (count = 0; count < this.charButtonArray.length; ++count) {
            this.charButtonArray[count].addActionListener(this);
            OrderMateThemeI.Helper.setupKeypadButton(this.charButtonArray[count]);
            this.charButtonArray[count].setBorder(null);
        }
    }

    final Keyboard getCurrentKeyboard() {
        return this.currentKeyboard;
    }

    static final KeyboardPanel getInstance() {
        return instance;
    }

    final void configure(Keyboard keyboard) {
        if (this.currentKeyboard != null && keyboard == this.currentKeyboard) {
            return;
        }
        if (this.currentKeyboard != null) {
            this.keyboardPanel.removeAncestorListener(this.currentKeyboard);
            this.currentKeyboard.remove(this.keyboardPanel);
            this.currentKeyboard.validate();
            this.lostKeySlot.setActive(false);
            this.currentKeyboard = null;
        }
        if (keyboard != null) {
            this.currentKeyboard = keyboard;
            this.resize();
            this.currentKeyboard.add((Component)this.keyboardPanel, "0,0,CENTER, TOP");
            this.keyboardPanel.addAncestorListener(this.currentKeyboard);
            this.keyboardPanel.invalidate();
            this.keyboardPanel.validate();
            this.currentKeyboard.validate();
            this.currentKeyboard.repaint();
            this.lostKeySlot.setActive(true);
            String string = this.currentKeyboard.getInitialString();
        }
    }

    private void resize() {
        int count;
        KeyboardDimensions dimensions = this.currentKeyboard != null ? this.currentKeyboard.getDimensions() : DefaultKeyboardDimensions.getInstance();
        if (this.currentDimensions == dimensions) {
            return;
        }
        this.currentDimensions = dimensions;
        this.construct();
        for (count = 0; count < this.numbButtonArray.length; ++count) {
            this.numbButtonArray[count].setPreferredSize(dimensions.getCharacterDimension());
        }
        for (count = 0; count < this.charButtonArray.length; ++count) {
            this.charButtonArray[count].setPreferredSize(dimensions.getCharacterDimension());
        }
        for (count = 0; count < this.functionButtonArray.length; ++count) {
            if (this.functionButtonArray[count].getText() == BACKSPACE) {
                this.functionButtonArray[count].setPreferredSize(dimensions.getBackspaceDimension());
                continue;
            }
            if (this.functionButtonArray[count].getText() == SPACE) {
                this.functionButtonArray[count].setPreferredSize(dimensions.getSpaceDimension());
                continue;
            }
            if (this.functionButtonArray[count].getText() == TAB) {
                this.functionButtonArray[count].setPreferredSize(dimensions.getTabDimension());
                continue;
            }
            if (this.functionButtonArray[count].getText() == BACKSLASH) {
                this.functionButtonArray[count].setPreferredSize(dimensions.getBackslashDimension());
                continue;
            }
            if (this.functionButtonArray[count].getText() == ENTER) {
                this.functionButtonArray[count].setPreferredSize(dimensions.getEnterDimension());
                continue;
            }
            this.functionButtonArray[count].setPreferredSize(dimensions.getCharacterDimension());
        }
        this.capsLockButton.setPreferredSize(dimensions.getCapsLockDimension());
        this.shiftButton.setPreferredSize(dimensions.getShiftDimension());
        this.shiftButton2.setPreferredSize(dimensions.getShift2Dimension());
        this.ctrlButton.setPreferredSize(dimensions.getCtrlAndAltDimension());
        this.clearButton.setPreferredSize(dimensions.getCtrlAndAltDimension());
        this.altButton.setPreferredSize(dimensions.getCtrlAndAltDimension());
        this.setAdvancedButtonsEnabled(this.currentKeyboard.isAdvancedButtonsEnabled());
        this.shiftButton.setSelected(true);
        this.setCaps(true);
    }

    private void construct() {
        this.keyboardPanel.removeAll();
        if (this.rows != null) {
            for (JPanel row : this.rows) {
                row.removeAll();
            }
        }
        KeyboardDimensions dimensions = this.currentDimensions;
        double p = -1.0;
        this.rows = new JPanel[5];
        this.rows[0] = new JPanel();
        double[] topRow = new double[14];
        Arrays.fill(topRow, (double)dimensions.getCharacterDimension().width);
        topRow[topRow.length - 1] = p;
        this.rows[0].setLayout((LayoutManager)new TableLayout((double[][])new double[][]{topRow, {p}}));
        this.rows[0].add((Component)this.tildeButton, "0,0, CENTER, TOP");
        this.rows[0].add((Component)this.oneButton, "1,0, CENTER, TOP");
        this.rows[0].add((Component)this.twoButton, "2,0, CENTER, TOP");
        this.rows[0].add((Component)this.threeButton, "3,0, CENTER, TOP");
        this.rows[0].add((Component)this.fourButton, "4,0, CENTER, TOP");
        this.rows[0].add((Component)this.fiveButton, "5,0, CENTER, TOP");
        this.rows[0].add((Component)this.sixButton, "6,0,CENTER, TOP");
        this.rows[0].add((Component)this.sevenButton, "7,0,CENTER, TOP");
        this.rows[0].add((Component)this.eightButton, "8,0,CENTER, TOP");
        this.rows[0].add((Component)this.nineButton, "9,0,CENTER, TOP");
        this.rows[0].add((Component)this.zeroButton, "10,0,CENTER, TOP");
        this.rows[0].add((Component)this.dashButton, "11,0,CENTER, TOP");
        this.rows[0].add((Component)this.underScoreButton, "12,0,CENTER,TOP");
        this.rows[0].add((Component)this.backspaceButton, "13,0,CENTER, TOP");
        double[] qRow = new double[13];
        Arrays.fill(qRow, (double)dimensions.getCharacterDimension().width);
        qRow[0] = dimensions.getTabDimension().width;
        qRow[qRow.length - 1] = p;
        this.rows[1] = new JPanel();
        this.rows[1].setLayout((LayoutManager)new TableLayout((double[][])new double[][]{qRow, {p}}));
        this.rows[1].add((Component)this.tabButton, "0,0,CENTER, TOP");
        this.rows[1].add((Component)this.qButton, "1,0,CENTER, TOP");
        this.rows[1].add((Component)this.wButton, "2,0,CENTER, TOP");
        this.rows[1].add((Component)this.eButton, "3,0,CENTER, TOP");
        this.rows[1].add((Component)this.rButton, "4,0,CENTER, TOP");
        this.rows[1].add((Component)this.tButton, "5,0,CENTER, TOP");
        this.rows[1].add((Component)this.yButton, "6,0,CENTER, TOP");
        this.rows[1].add((Component)this.uButton, "7,0,CENTER, TOP");
        this.rows[1].add((Component)this.iButton, "8,0,CENTER, TOP");
        this.rows[1].add((Component)this.oButton, "9,0,CENTER, TOP");
        this.rows[1].add((Component)this.pButton, "10,0,CENTER, TOP");
        this.rows[1].add((Component)this.atButton, "11,0,CENTER, TOP");
        this.rows[1].add((Component)this.backslashButton, "12,0,CENTER, TOP");
        double[] aRow = new double[12];
        Arrays.fill(aRow, (double)dimensions.getCharacterDimension().width);
        aRow[0] = dimensions.getCapsLockDimension().width;
        aRow[aRow.length - 1] = p;
        this.rows[2] = new JPanel();
        this.rows[2].setLayout((LayoutManager)new TableLayout((double[][])new double[][]{aRow, {p}}));
        this.rows[2].add((Component)this.capsLockButton, "0,0,CENTER, TOP");
        this.rows[2].add((Component)this.aButton, "1,0,CENTER, TOP");
        this.rows[2].add((Component)this.sButton, "2,0,CENTER, TOP");
        this.rows[2].add((Component)this.dButton, "3,0,CENTER, TOP");
        this.rows[2].add((Component)this.fButton, "4,0,CENTER, TOP");
        this.rows[2].add((Component)this.gButton, "5,0,CENTER, TOP");
        this.rows[2].add((Component)this.hButton, "6,0,CENTER, TOP");
        this.rows[2].add((Component)this.jButton, "7,0,CENTER, TOP");
        this.rows[2].add((Component)this.kButton, "8,0,CENTER, TOP");
        this.rows[2].add((Component)this.lButton, "9,0,CENTER, TOP");
        this.rows[2].add((Component)this.semicolonButton, "10,0,CENTER, TOP");
        this.rows[2].add((Component)this.enterButton, "11,0,CENTER, TOP");
        double[] zRow = new double[12];
        Arrays.fill(zRow, (double)dimensions.getCharacterDimension().width);
        zRow[0] = dimensions.getShiftDimension().width;
        zRow[zRow.length - 1] = p;
        this.rows[3] = new JPanel();
        this.rows[3].setLayout((LayoutManager)new TableLayout((double[][])new double[][]{zRow, {p}}));
        this.rows[3].add((Component)this.shiftButton, "0,0,CENTER, TOP");
        this.rows[3].add((Component)this.zButton, "1,0,CENTER, TOP");
        this.rows[3].add((Component)this.xButton, "2,0,CENTER, TOP");
        this.rows[3].add((Component)this.cButton, "3,0,CENTER, TOP");
        this.rows[3].add((Component)this.vButton, "4,0,CENTER, TOP");
        this.rows[3].add((Component)this.bButton, "5,0,CENTER, TOP");
        this.rows[3].add((Component)this.nButton, "6,0,CENTER, TOP");
        this.rows[3].add((Component)this.mButton, "7,0,CENTER, TOP");
        this.rows[3].add((Component)this.commaButton, "8,0,CENTER, TOP");
        this.rows[3].add((Component)this.fullStopButton, "9,0,CENTER, TOP");
        this.rows[3].add((Component)this.forwardSlashButton, "10,0,CENTER, TOP");
        this.rows[3].add((Component)this.shiftButton2, "11,0,CENTER, TOP");
        double[] bottomRow = new double[]{dimensions.getCtrlAndAltDimension().width, dimensions.getCtrlAndAltDimension().width, dimensions.getSpaceDimension().width, p, p};
        this.rows[4] = new JPanel();
        this.rows[4].setLayout((LayoutManager)new TableLayout((double[][])new double[][]{bottomRow, {p}}));
        this.rows[4].add((Component)this.ctrlButton, "0,0,CENTER, TOP");
        this.rows[4].add((Component)this.altButton, "1,0,CENTER, TOP");
        this.rows[4].add((Component)this.spaceButton, "2,0,CENTER, TOP");
        this.rows[4].add((Component)this.clearButton, "4,0,CENTER, TOP");
        this.keyboardPanel.add((Component)this.rows[0], "0,0,CENTER, TOP");
        this.keyboardPanel.add((Component)this.rows[1], "0,1,CENTER, TOP");
        this.keyboardPanel.add((Component)this.rows[2], "0,2,CENTER, TOP");
        this.keyboardPanel.add((Component)this.rows[3], "0,3,CENTER, TOP");
        this.keyboardPanel.add((Component)this.rows[4], "0,4,CENTER, TOP");
    }

    private void gotCapsLockPressed() {
        this.shiftButton.setSelected(false);
        this.shiftButton2.setSelected(false);
        this.setCaps(this.capsLockButton.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.backspaceButton) {
            this.currentKeyboard.gotDelete();
        } else if (source == this.spaceButton) {
            this.currentKeyboard.gotString(" ");
        } else if (source == this.tabButton) {
            this.currentKeyboard.gotString("   ");
        } else if (source == this.capsLockButton) {
            this.gotCapsLockPressed();
        } else {
            if (source == this.enterButton) {
                return;
            }
            if (source == this.shiftButton) {
                if (this.shiftButton.isSelected() && this.shiftButton2.isSelected()) {
                    this.shiftButton2.setSelected(false);
                }
                if (this.shiftButton.isSelected() && this.capsLockButton.isSelected()) {
                    this.setCaps(false);
                } else if (this.shiftButton.isSelected() && !this.capsLockButton.isSelected()) {
                    this.setCaps(true);
                } else if (!this.shiftButton.isSelected() && this.capsLockButton.isSelected()) {
                    this.setCaps(true);
                } else if (!this.shiftButton.isSelected() && !this.capsLockButton.isSelected()) {
                    this.setCaps(false);
                }
            } else if (source == this.shiftButton2) {
                if (this.shiftButton.isSelected() && this.shiftButton2.isSelected()) {
                    this.shiftButton.setSelected(false);
                }
                if (this.shiftButton2.isSelected() && this.capsLockButton.isSelected()) {
                    this.setCaps(false);
                } else if (this.shiftButton2.isSelected() && !this.capsLockButton.isSelected()) {
                    this.setCaps(true);
                } else if (!this.shiftButton2.isSelected() && this.capsLockButton.isSelected()) {
                    this.setCaps(true);
                } else if (!this.shiftButton2.isSelected() && !this.capsLockButton.isSelected()) {
                    this.setCaps(false);
                }
            } else {
                if (source == this.ctrlButton) {
                    return;
                }
                if (source == this.clearButton) {
                    this.currentKeyboard.clear();
                    return;
                }
                if (source == this.altButton) {
                    return;
                }
                if (source == this.oneButton || source == this.twoButton || source == this.threeButton || source == this.fourButton || source == this.fiveButton || source == this.sixButton || source == this.sevenButton || source == this.eightButton || source == this.nineButton || source == this.zeroButton || source == this.qButton || source == this.wButton || source == this.eButton || source == this.rButton || source == this.tButton || source == this.yButton || source == this.uButton || source == this.iButton || source == this.oButton || source == this.pButton || source == this.aButton || source == this.sButton || source == this.dButton || source == this.fButton || source == this.gButton || source == this.hButton || source == this.jButton || source == this.kButton || source == this.lButton || source == this.zButton || source == this.xButton || source == this.cButton || source == this.vButton || source == this.bButton || source == this.nButton || source == this.mButton || source == this.dashButton || source == this.tildeButton || source == this.backslashButton || source == this.commaButton || source == this.fullStopButton || source == this.forwardSlashButton || source == this.atButton || source == this.underScoreButton || source == this.semicolonButton) {
                    JButton clickedButton = (JButton)source;
                    String toEnter = clickedButton.getText();
                    this.currentKeyboard.gotString(toEnter);
                }
            }
        }
    }

    private void setAdvancedButtonsEnabled(boolean enabled) {
        this.ctrlButton.setEnabled(enabled);
        this.altButton.setEnabled(enabled);
        this.enterButton.setEnabled(enabled);
        this.tabButton.setEnabled(enabled);
    }

    void enableNumbersOnly(boolean enabled) {
        int count;
        for (count = 0; count < this.charButtonArray.length; ++count) {
            this.charButtonArray[count].setEnabled(!enabled);
        }
        for (count = 0; count < this.functionButtonArray.length; ++count) {
            this.functionButtonArray[count].setEnabled(!enabled);
        }
        for (count = 0; count < this.toggleButtonArray.length; ++count) {
            this.toggleButtonArray[count].setEnabled(!enabled);
        }
        this.backspaceButton.setEnabled(true);
    }

    void enableKeys(boolean enabled) {
        int count;
        for (count = 0; count < this.numbButtonArray.length; ++count) {
            this.numbButtonArray[count].setEnabled(enabled);
        }
        for (count = 0; count < this.charButtonArray.length; ++count) {
            this.charButtonArray[count].setEnabled(enabled);
        }
        for (count = 0; count < this.functionButtonArray.length; ++count) {
            this.functionButtonArray[count].setEnabled(enabled);
        }
        for (count = 0; count < this.toggleButtonArray.length; ++count) {
            this.toggleButtonArray[count].setEnabled(enabled);
        }
        this.shiftButton.setSelected(false);
    }

    void setCaps(boolean toUpper) {
        block3: {
            String charOrder;
            block2: {
                charOrder = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                if (!toUpper) break block2;
                char[] charArray = charOrder.toCharArray();
                for (int count = 0; count < charArray.length; ++count) {
                    char current = charArray[count];
                    current = Character.toUpperCase(current);
                    this.charButtonArray[count].setText(Character.toString(current));
                }
                break block3;
            }
            if (toUpper) break block3;
            char[] charArray = charOrder.toCharArray();
            for (int count = 0; count < charArray.length; ++count) {
                char current = charArray[count];
                current = Character.toLowerCase(current);
                this.charButtonArray[count].setText(Character.toString(current));
            }
        }
    }

    void setShift(boolean on) {
        this.shiftButton.setSelected(on);
        this.shiftButton2.setSelected(on);
        this.setCaps(on);
    }

    void setCapsLockButton(boolean on) {
        this.capsLockButton.setSelected(on);
    }

    void setShortNames(boolean value) {
        if (value) {
            this.capsLockButton.setText(CAPSLOCK_SHORT);
            this.backspaceButton.setText(BACKSPACE_SHORT);
        } else {
            this.capsLockButton.setText(CAPSLOCK);
            this.backspaceButton.setText(BACKSPACE);
        }
        this.keyboardPanel.validate();
    }

    public void gotClear() {
        this.currentKeyboard.clear();
    }

    public void gotDelete() {
        this.currentKeyboard.gotDelete();
    }

    public void gotString(String value) {
        this.currentKeyboard.gotString(value);
    }

    public void ancestorAdded(AncestorEvent event) {
        this.lostKeySlot.setActive(true);
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.lostKeySlot.setActive(false);
    }

    public boolean isShiftSelected() {
        return this.shiftButton.isSelected() || this.shiftButton2.isSelected();
    }

    public boolean isCapsSelected() {
        return this.capsLockButton.isSelected();
    }
}

