/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.keypad;

import au.com.ordermate.OrderMateLog;
import ordermate.gui.keypad.AbstractKeypadModel;

public class DoubleModel
extends AbstractKeypadModel {
    private static final char DECIMAL_POINT = '.';
    private final int INITIAL_MAX_CHARS;
    private static final int MAX_CHARS_WITH_DECIMAL = 16;

    public DoubleModel() {
        this(10);
    }

    public DoubleModel(int maxDigitsPerDecimalPoint) {
        this.INITIAL_MAX_CHARS = maxDigitsPerDecimalPoint;
        this.setMaxChars(this.INITIAL_MAX_CHARS);
    }

    @Override
    public void addToValue(char c) {
        int decimalPos;
        if (c == '.') {
            this.setMaxChars(16);
            if (this.value.indexOf(c) == -1) {
                this.value = this.value + String.valueOf(c);
            }
        } else if (this.value.length() < this.getMaxChars() && ((decimalPos = this.value.indexOf(46)) == -1 || this.allowAnotherDecimalPlace())) {
            this.value = this.value + String.valueOf(c);
        }
    }

    @Override
    public void backButtonClicked() {
        if (this.value.length() > 0) {
            String newValue = this.value.substring(0, this.value.length() - 1);
            if (newValue.indexOf(46) == -1) {
                this.setMaxChars(this.INITIAL_MAX_CHARS);
            } else {
                this.setMaxChars(16);
            }
            this.value = newValue;
        }
    }

    @Override
    public void setValue(String newValue) {
        if (newValue.equalsIgnoreCase("")) {
            this.value = "";
            return;
        }
        try {
            double val = Double.parseDouble(newValue);
            this.value = String.valueOf(val);
        }
        catch (NumberFormatException e) {
            this.value = "";
            String s = "Unable to convert String to Double";
            OrderMateLog.LOG.error(s, (Throwable)e);
        }
    }

    @Override
    public void reset() {
        this.value = "";
        this.maxChars = this.INITIAL_MAX_CHARS;
    }

    public boolean allowAnotherDecimalPlace() {
        int decimalPos = this.value.indexOf(46);
        int decimalPosDist = this.value.length() - decimalPos;
        boolean allowDecimalPlace = decimalPosDist <= 3;
        return allowDecimalPlace;
    }
}

