/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.keypad;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import ordermate.gui.ButtonStyler;
import ordermate.gui.DefaultButtonStyler;
import ordermate.gui.InputAdapterFactory;
import ordermate.gui.LostKeyEventSlot;
import ordermate.gui.keypad.DoubleRenderer;
import ordermate.gui.keypad.IntRenderer;
import ordermate.gui.keypad.KeypadModel;
import ordermate.gui.keypad.PasswordRenderer;
import ordermate.gui.keypad.PercentageRenderer;
import ordermate.gui.keypad.PhoneRenderer;
import ordermate.gui.keypad.PriceRenderer;
import ordermate.gui.keypad.Renderer;
import ordermate.gui.keypad.StringModel;
import ordermate.gui.keypad.StringRenderer;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class Keypad
extends JPanel
implements ActionListener {
    public static final Renderer PASSWORD_RENDERER = new PasswordRenderer();
    public static final Renderer STRING_RENDERER = new StringRenderer();
    public static final Renderer INT_RENDERER = new IntRenderer();
    public static final Renderer DOUBLE_RENDERER = new DoubleRenderer();
    public static final Renderer PRICE_RENDERER = new PriceRenderer();
    public static final Renderer PHONE_RENDERER = new PhoneRenderer();
    public static final Renderer PERCENTAGE_RENDERER = new PercentageRenderer();
    public final Signal okPressed;
    private KeypadModel currentModel;
    private Renderer currentRenderer;
    private JLabel label;
    private JButton[] numberButtons;
    private JButton decimalButton;
    private JButton backButton;
    private JButton okButton;
    private JButton minusSignButton;
    private boolean overwrite;
    private boolean firstPress;
    private boolean labelInline;
    private static final Insets buttonInsets = new Insets(22, 31, 22, 31);
    public final Signal<String, ?, ?, ?, ?> updated = Signals.createSignal(String.class, "keypadValue");
    private static final char[] buttonValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    protected Keypad() {
        this.okPressed = Signals.createSignal();
    }

    public void resetModel() {
        this.currentModel.reset();
        this.update();
    }

    public void showMinusSign(boolean isShow) {
        this.minusSignButton.setEnabled(isShow);
        this.minusSignButton.setVisible(isShow);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.numberButtons.length; ++i) {
            this.numberButtons[i].setEnabled(enabled);
        }
        this.decimalButton.setEnabled(enabled);
        this.minusSignButton.setEnabled(enabled);
        this.backButton.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
    }

    public void setOverwrite(boolean doOverwrite) {
        this.overwrite = doOverwrite;
    }

    public void setButtonFont(Font newFont) {
        for (int i = 0; i < this.numberButtons.length; ++i) {
            this.numberButtons[i].setFont(newFont);
        }
        this.decimalButton.setFont(newFont);
        this.backButton.setFont(newFont);
    }

    public void setButtonInsets(Insets insets) {
        for (int i = 0; i < this.numberButtons.length; ++i) {
            this.numberButtons[i].setMargin(insets);
        }
        this.decimalButton.setMargin(insets);
        this.backButton.setMargin(insets);
    }

    public void setButtonSize(Dimension size) {
        for (int i = 0; i < this.numberButtons.length; ++i) {
            this.numberButtons[i].setPreferredSize(size);
            this.numberButtons[i].setSize(size);
        }
        this.decimalButton.setSize(size);
        this.decimalButton.setPreferredSize(size);
        this.backButton.setSize(size);
        this.backButton.setPreferredSize(size);
    }

    public void setValue(String newValue) {
        this.currentModel.setValue(newValue);
        this.update();
    }

    public void setMaximumValue(int newMaximum) {
        this.currentModel.setMaxChars(newMaximum);
        this.update();
    }

    public void setDecimalButtonVisible(boolean isVisible) {
        this.decimalButton.setVisible(isVisible);
    }

    public void setLabel(JLabel newLabel) {
        this.label = newLabel;
    }

    public void setBackIcon(ImageIcon newIcon) {
        this.backButton.setIcon(newIcon);
    }

    public void setModel(KeypadModel toUse) {
        this.currentModel = toUse;
        this.currentModel.reset();
        this.update();
    }

    public void setRenderer(Renderer toUse) {
        this.currentRenderer = toUse;
        this.update();
    }

    public String getValue() {
        return this.currentRenderer.renderValue(this.currentModel.getValue());
    }

    public String getValueAsString() {
        return STRING_RENDERER.renderValue(this.currentModel.getValue());
    }

    public int getValueAsInt() {
        String value = INT_RENDERER.renderValue(this.currentModel.getValue());
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String s = "Unable to convert String to Integer";
            OrderMateLog.LOG.error(s, (Throwable)e);
            return -1;
        }
    }

    public double getValueAsDouble() {
        String value = DOUBLE_RENDERER.renderValue(this.currentModel.getValue());
        if (value.startsWith(Internationalization.getLiteralFor("DOLLAR_SIGN"))) {
            value = value.substring(Internationalization.getLiteralFor("DOLLAR_SIGN").length(), value.length());
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            String s = "Unable to convert String to Double";
            OrderMateLog.LOG.error(s, (Throwable)e);
            return -1.0;
        }
    }

    public BigDecimal getValueAsBigDecimal() {
        String value = DOUBLE_RENDERER.renderValue(this.currentModel.getValue());
        if (value.startsWith(Internationalization.getLiteralFor("DOLLAR_SIGN"))) {
            value = value.substring(1, value.length());
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            String s = "Unable to convert String to Big Decimal";
            OrderMateLog.LOG.error(s, (Throwable)e);
            return null;
        }
    }

    public String getValueAsPrice() {
        return PRICE_RENDERER.renderValue(this.currentModel.getValue());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.backButton) {
            this.deleteEntered();
        } else if (source == this.okButton) {
            this.okPressed.emit();
        } else if (source == this.decimalButton) {
            this.charEntered('.');
        } else if (source == this.minusSignButton) {
            this.charEntered('-');
        } else {
            for (int i = 0; i < this.numberButtons.length; ++i) {
                if (source != this.numberButtons[i]) continue;
                this.charEntered(buttonValues[i]);
            }
        }
    }

    private void deleteEntered() {
        this.currentModel.backButtonClicked();
        this.setFirstPress(false);
        this.setOverwrite(false);
        this.update();
    }

    private void charEntered(char toEnter) {
        if (Character.isDigit(toEnter) || toEnter == '.' || toEnter == '-') {
            if (this.firstPress || this.overwrite) {
                this.clearEntered();
            }
            this.currentModel.addToValue(toEnter);
            this.setFirstPress(false);
        }
        this.update();
    }

    private void clearEntered() {
        this.currentModel.setValue("");
        this.setOverwrite(false);
        this.update();
    }

    private void update() {
        String modelValue = this.currentModel.getValue();
        String value = this.currentRenderer.renderValue(modelValue);
        if (this.label != null) {
            this.label.setText(value);
        }
        this.updated.emit(value);
    }

    public void setFirstPress(boolean newFirstPress) {
        this.firstPress = newFirstPress;
    }

    public boolean getFirstPress() {
        return this.firstPress;
    }

    public void setLabelInline(boolean newLabelInline) {
        this.labelInline = newLabelInline;
    }

    public boolean isLabelInline() {
        return this.labelInline;
    }

    static /* synthetic */ JButton[] access$002(Keypad x0, JButton[] x1) {
        x0.numberButtons = x1;
        return x1;
    }

    public static class HorizontalKeypadBuilder
    extends KeypadBuilder {
        private static final Insets buttonInsets = new Insets(15, 2, 15, 2);
        private boolean showDecimal;

        public HorizontalKeypadBuilder() {
            this.setUsePhysicalKeyboardListener(false);
        }

        @Override
        public Keypad build() {
            Keypad keypad = new Keypad();
            this.setup(keypad);
            keypad.setLabelInline(true);
            return keypad;
        }

        public HorizontalKeypadBuilder setShowDecimal(boolean showDecPlace) {
            this.showDecimal = showDecPlace;
            return this;
        }

        @Override
        protected void layoutButtons(Keypad pad, JButton[] numbers, JButton decimal, JButton back, boolean showMinusSignButton) {
            if (pad == null) {
                throw new IllegalArgumentException("keypad should not be null");
            }
            if (numbers == null || numbers.length < 1) {
                throw new IllegalArgumentException("Numbers was invalid :" + numbers);
            }
            if (decimal == null) {
                throw new IllegalArgumentException("Decimal button should not be null");
            }
            if (back == null) {
                throw new IllegalArgumentException("Back button should not be null");
            }
            ArrayList<JButton> buttons = new ArrayList<JButton>(Arrays.asList(numbers));
            if (this.showDecimal) {
                buttons.add(1, decimal);
            }
            buttons.add(back);
            this.layoutButtons(pad, buttons);
        }

        private void layoutButtons(Keypad pad, List<JButton> buttons) {
            pad.setLayout(new GridLayout(1, buttons.size(), this.getButtonPadding(), this.getButtonPadding()));
            int index = 0;
            for (JButton currentButton : buttons) {
                pad.add((Component)currentButton, new Rectangle(index + 1, 0, 1, 1));
                currentButton.setMargin(buttonInsets);
            }
        }
    }

    public static class KeypadBuilder {
        private JLabel outputLabel;
        private int buttonPadding = 10;
        private String padName = "keypad";
        private boolean showOkButton;
        private boolean showMinusSignButton;
        private boolean usePhysicalKeyboardListener = true;
        private ButtonStyler styler = new DefaultButtonStyler();

        public Keypad build() {
            Keypad pad = new Keypad();
            pad.setName(this.padName);
            return this.setup(pad);
        }

        public KeypadBuilder setStyler(ButtonStyler theStyler) {
            this.styler = theStyler;
            return this;
        }

        public KeypadBuilder setUsePhysicalKeyboardListener(boolean useIt) {
            this.usePhysicalKeyboardListener = useIt;
            return this;
        }

        protected Keypad setup(Keypad pad) {
            pad.setLabelInline(false);
            Keypad.access$002(pad, new JButton[10]);
            for (int i = 0; i < pad.numberButtons.length; ++i) {
                ((Keypad)pad).numberButtons[i] = new JButton(Integer.toString(i));
                pad.numberButtons[i].setName("NumKeypad " + i);
                this.setupButton(pad, pad.numberButtons[i]);
            }
            pad.backButton = new JButton(new ImageIcon(this.getClass().getResource("/waitermate/images/leftarrow.gif")));
            pad.backButton.setText(null);
            this.setupButton(pad, pad.backButton);
            if (this.showOkButton) {
                pad.okButton = new JButton(IconLoader.get("/waitermate/images/key_small.png"));
                pad.okButton.setName("keypadOk");
                this.setupButton(pad, pad.okButton);
            }
            if (this.showMinusSignButton) {
                pad.minusSignButton = new JButton("-");
                pad.minusSignButton.setName("minusSign");
                this.setupButton(pad, pad.minusSignButton);
            }
            pad.decimalButton = new JButton(".");
            pad.decimalButton.setName("decimalButton");
            this.setupButton(pad, pad.decimalButton);
            if (!this.showOkButton) {
                this.layoutButtons(pad, pad.numberButtons, pad.decimalButton, pad.backButton, this.showMinusSignButton);
            } else {
                this.layoutButtons(pad, pad.numberButtons, pad.backButton, pad.okButton, this.showMinusSignButton);
            }
            pad.currentModel = new StringModel();
            pad.currentRenderer = STRING_RENDERER;
            pad.setOverwrite(false);
            pad.setFirstPress(true);
            pad.label = this.outputLabel;
            if (this.usePhysicalKeyboardListener) {
                AncestorListener listener = this.createKeyboardListener(pad);
                pad.addAncestorListener(listener);
            }
            return pad;
        }

        private void setupButton(Keypad pad, AbstractButton button) {
            button.addActionListener(pad);
            this.styler.styleButton(button);
        }

        private AncestorListener createKeyboardListener(final Keypad pad) {
            final LostKeyEventSlot lostKeySlot = new LostKeyEventSlot(InputAdapterFactory.getAdapter()){

                @Override
                public void onLostEvent(KeyEvent e) {
                    char keyChar = e.getKeyChar();
                    if (keyChar == '\b' || keyChar == '\u007f') {
                        pad.deleteEntered();
                    } else if (keyChar == '\u001b') {
                        pad.clearEntered();
                    } else {
                        pad.charEntered(keyChar);
                    }
                }
            };
            return new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    lostKeySlot.setActive(true);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    lostKeySlot.setActive(false);
                }
            };
        }

        protected void layoutButtons(Keypad pad, JButton[] numbers, JButton bottomLeft, JButton bottomRight, boolean showMinusSign) {
            JPanel pane = new JPanel();
            if (!showMinusSign) {
                pane.setLayout(new GridLayout(4, 3, this.buttonPadding, this.buttonPadding));
            } else {
                pane.setLayout(new GridLayout(5, 3, this.buttonPadding, this.buttonPadding));
            }
            pane.setOpaque(false);
            for (int i = 1; i < numbers.length; ++i) {
                pane.add(numbers[i]);
                numbers[i].setMargin(buttonInsets);
            }
            bottomLeft.setMargin(buttonInsets);
            numbers[0].setMargin(buttonInsets);
            bottomRight.setMargin(buttonInsets);
            pane.add(bottomLeft);
            pane.add(numbers[0]);
            pane.add(bottomRight);
            if (showMinusSign) {
                pad.minusSignButton.setMargin(buttonInsets);
                pane.add(pad.minusSignButton);
            }
            pad.setLayout(new BorderLayout());
            pad.add("Center", pane);
        }

        public KeypadBuilder setOutputLabel(JLabel lable) {
            this.outputLabel = lable;
            return this;
        }

        public KeypadBuilder setButtonPadding(int padding) {
            this.buttonPadding = padding;
            return this;
        }

        public KeypadBuilder setShowOkButton(boolean value) {
            this.showOkButton = value;
            return this;
        }

        public KeypadBuilder setShowMinusSignButton(boolean value) {
            this.showMinusSignButton = value;
            return this;
        }

        protected int getButtonPadding() {
            return this.buttonPadding;
        }

        public KeypadBuilder setPadName(String string) {
            this.padName = string;
            return this;
        }
    }
}

