/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.keypad;

import au.com.ordermate.util.StringUtils;
import ordermate.gui.keypad.AbstractKeypadModel;

public class PriceModel
extends AbstractKeypadModel {
    private static final char DECIMAL_POINT = '.';
    private static final char DOLLAR_SIGN = '$';
    private static final int INITIAL_MAX_CHARS = 6;
    private static final int MAX_CHARS_WITH_DECIMAL = 8;

    public PriceModel() {
        this.setMaxChars(6);
    }

    @Override
    public void addToValue(char c) {
        int decimalPos;
        if (c == '.') {
            this.setMaxChars(8);
            if (this.value.indexOf(c) == -1) {
                this.value = this.value + String.valueOf(c);
            }
        } else if (this.value.length() < this.getMaxChars() && ((decimalPos = this.value.indexOf(46)) == -1 || this.allowAnotherDecimalPlace())) {
            this.value = this.value + String.valueOf(c);
        }
    }

    @Override
    public void setValue(String newVal) {
        String newValue = newVal;
        if (newValue == null) {
            newValue = "";
        }
        this.value = newValue.indexOf(36) != -1 ? StringUtils.removeChar(newValue, '$') : newValue;
    }

    @Override
    public void reset() {
        this.value = "";
        this.maxChars = 6;
    }

    @Override
    public void backButtonClicked() {
        if (this.value.length() > 0) {
            String newValue = this.value.substring(0, this.value.length() - 1);
            if (newValue.indexOf(46) == -1) {
                this.setMaxChars(6);
            } else {
                this.setMaxChars(8);
            }
            this.value = newValue;
        }
    }

    public boolean allowAnotherDecimalPlace() {
        int decimalPos = this.value.indexOf(46);
        int decimalPosDist = this.value.length() - decimalPos;
        boolean allowDecimalPlace = decimalPosDist <= 2;
        return allowDecimalPlace;
    }
}

