/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.modify.security;

import java.awt.Component;
import java.awt.Container;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JMenu;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.gui.modify.security.SecurityDecorator;
import ordermate.gui.modify.security.UserSecurityManager;

public abstract class AbstractUserSecurityManager<T extends User>
implements UserSecurityManager<T> {
    private final Set<SecurityDecorator> components = new LinkedHashSet<SecurityDecorator>();
    private User user;

    @Override
    public void componentAdded(Component comp) {
        if (comp instanceof Container) {
            Container container = (Container)comp;
            Component[] children = container.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.componentAdded(children[i]);
            }
        }
        if (comp instanceof SecurityDecorator) {
            this.components.add((SecurityDecorator)((Object)comp));
            this.setupComponent((SecurityDecorator)((Object)comp));
        }
    }

    @Override
    public void componentRemoved(Component comp) {
        if (comp instanceof Container) {
            Container container = (Container)comp;
            Component[] children = container.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.componentRemoved(children[i]);
            }
        }
        if (comp instanceof JMenu) {
            Component[] arrComp = ((JMenu)comp).getMenuComponents();
            for (int i = 0; i < arrComp.length; ++i) {
                this.componentRemoved(arrComp[i]);
            }
        }
        if (comp instanceof SecurityDecorator) {
            this.components.remove(comp);
        }
    }

    protected void setupComponent(SecurityDecorator toConfig) {
        Permission permission = toConfig.getPermission();
        if (permission == null) {
            toConfig.setSecurityEnabled(true);
            toConfig.setSecurityVisible(true);
        } else if (this.user == null) {
            toConfig.setSecurityEnabled(false);
            toConfig.setSecurityVisible(true);
        } else {
            String accessLevel = this.resolveAccessLevel(permission);
            if (accessLevel.equals("ENABLED")) {
                toConfig.setSecurityEnabled(true);
                toConfig.setSecurityVisible(true);
            } else if (accessLevel.equals("DISABLED")) {
                toConfig.setSecurityEnabled(false);
                toConfig.setSecurityVisible(true);
            } else if (accessLevel.equals("HIDDEN")) {
                toConfig.setSecurityEnabled(false);
                toConfig.setSecurityVisible(false);
            }
        }
    }

    protected abstract String resolveAccessLevel(Permission var1);

    @Override
    public void gotNewUser(User newUser) {
        this.user = newUser;
        for (SecurityDecorator toChange : this.components) {
            this.setupComponent(toChange);
        }
    }

    @Override
    public void gotNoUser() {
        this.user = null;
    }

    protected User getUser() {
        return this.user;
    }
}

