/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.modify.security;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import java.util.List;
import javax.persistence.Transient;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;
import ordermate.gui.modify.security.AbstractUserSecurityManager;

public class PosUserSecurityManager
extends AbstractUserSecurityManager<User> {
    private LocalCacheListManager<PermissionGroup> cachedPermissionGroups;

    @Override
    public boolean hasPermission(Permission permission) {
        return this.getUser() != null && this.getUser().hasPermission(permission);
    }

    @Override
    protected String resolveAccessLevel(Permission permission) {
        return this.getUser().getPermissionAccessLevel(permission);
    }

    @Override
    public List<User> getUsers() {
        return PersistenceManager.getObjectList(User.class, Query.select(User.class).active(User.class).equals(User.Properties.HIDDEN, 0.0).orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME).toString());
    }

    private synchronized LocalCacheListManager<PermissionGroup> getPermissionGroupList() {
        if (this.cachedPermissionGroups == null) {
            this.cachedPermissionGroups = new LocalCacheListManager<PermissionGroup>(Query.createQueryList(PermissionGroup.class, Query.select(PermissionGroup.class).active(PermissionGroup.class).orderBy(PermissionGroup.Properties.LEVEL)));
        }
        return this.cachedPermissionGroups;
    }

    @Override
    @Transient
    public PermissionGroup getCachedPermissionGroup(PersistentObjDescriptor<PermissionGroup> desc) {
        PermissionGroup group;
        if (desc.getID() != null) {
            int id = desc.getID().intValue();
            PermissionGroup cachedGroup = this.getPermissionGroupList().getByID(id);
            if (cachedGroup != null) {
                return cachedGroup;
            }
        }
        if ((group = desc.resolveObject()) != null) {
            return PersistenceManager.preload(group);
        }
        return null;
    }
}

