/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.modify.security;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import ordermate.database.users.Permission;
import ordermate.gui.modify.security.SecurityDecorator;

public class SecurityMenu
extends JMenu
implements SecurityDecorator {
    private Permission permission;
    private boolean securityOn = true;
    private boolean securityEnabled = true;
    private boolean businessEnabled = true;
    private boolean securityVisible = true;
    private boolean businessVisible = true;

    public SecurityMenu(Permission perm) {
        this.permission = perm;
    }

    public SecurityMenu(String text, Permission perm) {
        super(text);
        this.permission = perm;
    }

    @Override
    public JComponent getDecorateComponent() {
        return this;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    @Override
    public void setPermission(Permission perm) {
        this.permission = perm;
    }

    @Override
    public void setSecurityOn(boolean on) {
        this.securityOn = on;
        this.processChanges();
    }

    private boolean anyChildrenEnabled() {
        Component[] children = this.getMenuComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].isEnabled()) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildrenVisible() {
        Component[] children = this.getMenuComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    private void processChanges() {
        boolean enabled;
        boolean bl = this.securityOn ? this.securityEnabled && this.businessEnabled && this.anyChildrenEnabled() : (enabled = this.businessEnabled);
        boolean visible = this.securityOn ? this.securityVisible && this.businessVisible && this.anyChildrenVisible() : this.businessVisible;
        super.setEnabled(enabled);
        super.setVisible(visible);
    }

    @Override
    public void setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
        this.processChanges();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.businessEnabled = enabled;
        this.processChanges();
    }

    @Override
    public void setSecurityVisible(boolean visible) {
        this.securityVisible = visible;
        this.processChanges();
    }

    @Override
    public void setVisible(boolean visible) {
        this.businessVisible = visible;
        this.processChanges();
    }
}

