/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.modify.security;

import au.com.ordermate.guicore.AbstractComponentDecorator;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import ordermate.database.users.Permission;
import ordermate.gui.modify.security.SecurityDecorator;

public class StandardSecurityDecorator
extends AbstractComponentDecorator
implements SecurityDecorator {
    private Permission permission;
    private boolean securityOn = true;
    private boolean securityEnabled = true;
    private boolean businessEnabled = true;
    private boolean securityVisible = true;
    private boolean businessVisible = true;

    public StandardSecurityDecorator(JComponent toDecorate, Permission newPermission) {
        super(toDecorate);
        this.permission = newPermission;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    @Override
    public void setPermission(Permission perm) {
        this.permission = perm;
    }

    @Override
    public void setSecurityOn(boolean on) {
        this.securityOn = on;
        this.processChanges();
    }

    private void processChanges() {
        boolean enabled = this.processEnabledStatus();
        boolean visible = this.processVisibleStatus();
        if (super.isEnabled() != enabled) {
            super.setEnabled(enabled);
        }
        if (super.isVisible() != visible) {
            super.setVisible(visible);
        }
    }

    protected boolean processEnabledStatus() {
        return this.securityOn ? this.securityEnabled && this.businessEnabled : this.businessEnabled;
    }

    protected boolean processVisibleStatus() {
        return this.securityOn ? this.securityVisible && this.businessVisible : this.businessVisible;
    }

    @Override
    public void setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
        this.processChanges();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.businessEnabled = enabled;
        this.processChanges();
    }

    @Override
    public void setSecurityVisible(boolean visible) {
        this.securityVisible = visible;
        this.processChanges();
    }

    @Override
    public void setVisible(boolean visible) {
        this.businessVisible = visible;
        this.processChanges();
    }

    public AbstractButton getButton() {
        return (AbstractButton)this.getDecorateComponent();
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public Action createAction() {
        if (this.getDecorateComponent() instanceof AbstractButton) {
            Action buttonAction = ((AbstractButton)this.getDecorateComponent()).getAction();
            return new StandardSecurityDecoratorAction(buttonAction);
        }
        throw new IllegalStateException("This decorator doesn't decorate an actionable component.");
    }

    protected boolean isSecurityOn() {
        return this.securityOn;
    }

    protected boolean isBusinessEnabled() {
        return this.businessEnabled;
    }

    protected boolean isSecurityVisible() {
        return this.securityVisible;
    }

    protected boolean isBusinessVisible() {
        return this.businessVisible;
    }

    private class StandardSecurityDecoratorAction
    implements Action {
        private final Action wrappedAction;

        public StandardSecurityDecoratorAction(Action wrapThis) {
            this.wrappedAction = wrapThis;
        }

        @Override
        public void setEnabled(boolean value) {
            StandardSecurityDecorator.this.setEnabled(value);
        }

        @Override
        public boolean isEnabled() {
            return StandardSecurityDecorator.this.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.wrappedAction.actionPerformed(e);
        }

        @Override
        public Object getValue(String key) {
            return this.wrappedAction.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.wrappedAction.putValue(key, value);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.wrappedAction.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.wrappedAction.removePropertyChangeListener(listener);
        }
    }
}

